/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.capabilitysync.capabilitysync.tracker;

import com.sekwah.sekclib.capabilitysync.SyncEntry;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.ISyncTrackerData;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTrackerClone;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTrackerSerializer;
import java.util.Objects;

public class SyncTracker
implements ISyncTrackerData {
    protected SyncEntry syncEntry;
    protected Object sendValue;
    protected int minTicksLeft = 0;
    protected boolean markedForSend = false;

    public SyncTracker(SyncEntry syncEntry) {
        this.syncEntry = syncEntry;
    }

    public void tick(Object data) throws Throwable {
        if (--this.minTicksLeft <= 0) {
            Object currentData = this.syncEntry.getGetter().invoke(data);
            if (this.shouldSend(currentData)) {
                this.markedForSend = true;
                SyncTrackerSerializer syncTrackerSerializer = this.syncEntry.getSerializer();
                if (syncTrackerSerializer instanceof SyncTrackerClone) {
                    SyncTrackerClone cloner = (SyncTrackerClone)((Object)syncTrackerSerializer);
                    this.sendValue = cloner.clone(currentData);
                } else {
                    this.sendValue = currentData;
                }
                this.minTicksLeft = this.syncEntry.getMinTicks();
            } else {
                this.markedForSend = false;
            }
        } else {
            this.markedForSend = false;
        }
    }

    @Override
    public SyncEntry getSyncEntry() {
        return this.syncEntry;
    }

    @Override
    public Object getSendValue() {
        return this.sendValue;
    }

    protected boolean shouldSend(Object currentValue) {
        return !Objects.equals(this.sendValue, currentValue);
    }

    public boolean isMarkedForSend() {
        return this.markedForSend;
    }
}

