/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.network.s2c;

import com.sekwah.sekclib.SekCLib;
import com.sekwah.sekclib.capabilitysync.CapabilityEntry;
import com.sekwah.sekclib.capabilitysync.SyncEntry;
import com.sekwah.sekclib.capabilitysync.capabilitysync.broadcaster.CapabilityInfo;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.ISyncTrackerData;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTrackerData;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTrackerSerializer;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTrackerUpdater;
import com.sekwah.sekclib.registries.SekCLibRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientCapabilitySyncPacket {
    private final int entityId;
    public List<CapabilityInfo> capabilityData;
    private boolean includePrivate;

    public ClientCapabilitySyncPacket(LivingEntity entity, List<CapabilityInfo> capabilityData, boolean includePrivate) {
        this.entityId = entity.m_19879_();
        this.capabilityData = new ArrayList<CapabilityInfo>(capabilityData);
        this.includePrivate = includePrivate;
        if (!includePrivate) {
            this.capabilityData.removeIf(data -> data.changedEntries.isEmpty());
        }
    }

    private ClientCapabilitySyncPacket(int player, List<CapabilityInfo> capabilityData) {
        this.entityId = player;
        this.capabilityData = capabilityData;
    }

    public static void encodeSyncTrackers(List<ISyncTrackerData> trackers, FriendlyByteBuf outBuffer) {
        for (ISyncTrackerData tracker : trackers) {
            outBuffer.writeByte(tracker.getSyncEntry().getTrackerId());
            outBuffer.writeBoolean(tracker.getSendValue() != null);
            if (tracker.getSendValue() == null) continue;
            tracker.getSyncEntry().getSerializer().encode(tracker.getSendValue(), outBuffer);
        }
    }

    public static List<ISyncTrackerData> decodeSyncTrackers(CapabilityEntry capability, FriendlyByteBuf inBuffer) {
        int trackerCount = inBuffer.readInt();
        ArrayList<ISyncTrackerData> syncTrackerDataList = new ArrayList<ISyncTrackerData>();
        for (int i = 0; i < trackerCount; ++i) {
            byte trackerId = inBuffer.readByte();
            boolean hasData = inBuffer.readBoolean();
            SyncEntry tracker = capability.getSyncEntries().get(trackerId);
            Object data = hasData ? tracker.getSerializer().decode(inBuffer) : null;
            syncTrackerDataList.add(new SyncTrackerData(tracker, data));
        }
        return syncTrackerDataList;
    }

    public static void encode(ClientCapabilitySyncPacket msg, FriendlyByteBuf outBuffer) {
        outBuffer.writeInt(msg.entityId);
        outBuffer.writeInt(msg.capabilityData.size());
        for (CapabilityInfo capInfo : msg.capabilityData) {
            outBuffer.writeInt(capInfo.capabilityId);
            int count = capInfo.changedEntries.size();
            if (msg.includePrivate) {
                count += capInfo.changedPrivateEntries.size();
            }
            outBuffer.writeInt(count);
            ClientCapabilitySyncPacket.encodeSyncTrackers(capInfo.changedEntries, outBuffer);
            if (!msg.includePrivate) continue;
            ClientCapabilitySyncPacket.encodeSyncTrackers(capInfo.changedPrivateEntries, outBuffer);
        }
    }

    public static ClientCapabilitySyncPacket decode(FriendlyByteBuf inBuffer) {
        int playerId = inBuffer.readInt();
        int capCount = inBuffer.readInt();
        ArrayList<CapabilityInfo> capabilityInfoList = new ArrayList<CapabilityInfo>();
        for (int i = 0; i < capCount; ++i) {
            int capId = inBuffer.readInt();
            CapabilityEntry capability = (CapabilityEntry)SekCLibRegistries.CAPABILITY_REGISTRY.getValue(capId);
            List<ISyncTrackerData> syncTrackers = ClientCapabilitySyncPacket.decodeSyncTrackers(capability, inBuffer);
            if (syncTrackers.isEmpty()) continue;
            CapabilityInfo capInfo = new CapabilityInfo(capId, capability);
            capInfo.changedEntries.addAll(syncTrackers);
            capabilityInfoList.add(capInfo);
        }
        return new ClientCapabilitySyncPacket(playerId, capabilityInfoList);
    }

    public static class Handler {
        public static void handle(ClientCapabilitySyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                Entity entity = level.m_6815_(msg.entityId);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    for (CapabilityInfo capInfo : msg.capabilityData) {
                        livingEntity.getCapability(capInfo.capability.getCapability()).ifPresent(targetCap -> {
                            List<SyncEntry> syncEntries = capInfo.capability.getSyncEntries();
                            for (ISyncTrackerData syncTrackerData : capInfo.changedEntries) {
                                SyncEntry syncEntry = syncEntries.get(syncTrackerData.getSyncEntry().getTrackerId());
                                try {
                                    Object syncValue = syncTrackerData.getSendValue();
                                    SyncTrackerSerializer patt6488$temp = syncTrackerData.getSyncEntry().getSerializer();
                                    if (patt6488$temp instanceof SyncTrackerUpdater) {
                                        SyncTrackerUpdater updater = (SyncTrackerUpdater)((Object)patt6488$temp);
                                        updater.updateTracker(syncValue, syncEntry.getGetter().invoke(targetCap));
                                    }
                                    syncEntry.getSetter().invoke(targetCap, syncValue);
                                }
                                catch (Throwable e) {
                                    SekCLib.LOGGER.error("There was a problem setting a value", e);
                                }
                            }
                        });
                    }
                }
            }));
            context.setPacketHandled(true);
        }
    }
}

