/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.util;

import java.awt.Color;
import net.minecraft.network.chat.TextColor;

public class ColorUtil {
    public static Color recalculateHue(float hue, int brightness) {
        double radiansHue = Math.toRadians(hue);
        int red = (int)(Math.sqrt(Math.cos(radiansHue) + 0.0) * 255.0);
        int green = (int)(Math.sqrt(Math.cos(radiansHue - 2.0707963267948966) + 0.0) * 255.0);
        int blue = (int)(Math.sqrt(Math.cos(radiansHue + 2.0707963267948966) + 0.0) * 255.0);
        if (brightness > 50) {
            float multiValue = (float)(brightness - 50) / 50.0f;
            red = (int)((float)(255 - red) * multiValue + (float)red);
            green = (int)((float)(255 - green) * multiValue + (float)green);
            blue = (int)((float)(255 - blue) * multiValue + (float)blue);
        } else if (brightness < 50) {
            float multiValue = (float)brightness / 50.0f;
            red = (int)((float)red * multiValue);
            green = (int)((float)green * multiValue);
            blue = (int)((float)blue * multiValue);
        }
        return new Color(red, green, blue);
    }

    public static TextColor toMCColor(Color color) {
        return TextColor.m_131268_((String)String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
    }

    public int colorToInt(Color color) {
        return ColorUtil.toMCColor(color).m_131265_();
    }
}

