/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonTime;

public class SeasonHooks {
    public static boolean shouldSnowHook(Biome biome, LevelReader levelReader, BlockPos pos) {
        BlockState blockstate;
        if (((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && SeasonHooks.warmEnoughToRain(biome, pos, levelReader) || !((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && biome.m_198906_(pos)) {
            return false;
        }
        return pos.m_123342_() >= levelReader.m_141937_() && pos.m_123342_() < levelReader.m_151558_() && levelReader.m_45517_(LightLayer.BLOCK, pos) < 10 && (blockstate = levelReader.m_8055_(pos)).m_60795_() && Blocks.f_50125_.m_49966_().m_60710_(levelReader, pos);
    }

    public static boolean coldEnoughToSnowHook(Biome biome, BlockPos pos, LevelReader levelReader) {
        return !SeasonHooks.warmEnoughToRain(biome, pos, levelReader);
    }

    public static boolean tickChunkColdEnoughToSnowHook(Biome biome, BlockPos pos, LevelReader levelReader) {
        return (Boolean)SeasonsConfig.generateSnowAndIce.get() != false && SeasonHooks.coldEnoughToSnowHook(biome, pos, levelReader) || (Boolean)SeasonsConfig.generateSnowAndIce.get() == false && biome.m_198904_(pos);
    }

    private static boolean warmEnoughToRain(Biome biome, BlockPos pos, LevelReader levelReader) {
        Holder biomeHolder = levelReader.m_204166_(pos);
        return SeasonHooks.getBiomeTemperature(levelReader, (Holder<Biome>)biomeHolder, pos) >= 0.15f;
    }

    public static boolean warmEnoughToRainHook(Holder<Biome> biome, BlockPos pos, Level level) {
        return SeasonHooks.getBiomeTemperature(level, biome, pos) >= 0.15f;
    }

    public static boolean shouldFreezeWarmEnoughToRainHook(Biome biome, BlockPos pos, LevelReader levelReader) {
        return (Boolean)SeasonsConfig.generateSnowAndIce.get() != false && SeasonHooks.warmEnoughToRain(biome, pos, levelReader) || (Boolean)SeasonsConfig.generateSnowAndIce.get() == false && biome.m_198906_(pos);
    }

    public static boolean shouldSnowGolemBurnHook(Biome biome, BlockPos pos, LevelReader levelReader) {
        Holder biomeHolder = levelReader.m_204166_(pos);
        return SeasonHooks.getBiomeTemperature(levelReader, (Holder<Biome>)biomeHolder, pos) > 1.0f;
    }

    public static boolean isRainingAtHook(Level level, BlockPos position) {
        if (!level.m_46471_()) {
            return false;
        }
        if (!level.m_45527_(position)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, position).m_123342_() > position.m_123342_()) {
            return false;
        }
        Holder biome = level.m_204166_(position);
        if (ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_()) && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            if (SeasonHooks.shouldRainInBiomeInSeason(level, (Holder<Biome>)biome)) {
                if (biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)) {
                    return true;
                }
                return SeasonHooks.getBiomeTemperature(level, (Holder<Biome>)biome, position) >= 0.15f;
            }
            return false;
        }
        return ((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.RAIN && ((Biome)biome.m_203334_()).m_47505_(position) >= 0.15f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Biome.Precipitation getLevelRendererPrecipitation(Holder<Biome> biome) {
        Biome.Precipitation rainType = ((Biome)biome.m_203334_()).m_47530_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_()) && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) && (rainType == Biome.Precipitation.RAIN || rainType == Biome.Precipitation.NONE)) {
            if (SeasonHooks.shouldRainInBiomeInSeason((Level)level, biome)) {
                return Biome.Precipitation.RAIN;
            }
            return Biome.Precipitation.NONE;
        }
        return rainType;
    }

    public static float getBiomeTemperature(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        if (!(level instanceof Level)) {
            return ((Biome)biome.m_203334_()).m_47505_(pos);
        }
        return SeasonHooks.getBiomeTemperature((Level)level, biome, pos);
    }

    public static float getBiomeTemperature(Level level, Holder<Biome> biome, BlockPos pos) {
        if (!ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_())) {
            return ((Biome)biome.m_203334_()).m_47505_(pos);
        }
        return SeasonHooks.getBiomeTemperatureInSeason(new SeasonTime(SeasonHelper.getSeasonState(level).getSeasonCycleTicks()).getSubSeason(), biome, pos);
    }

    public static float getBiomeTemperatureInSeason(Season.SubSeason subSeason, Holder<Biome> biome, BlockPos pos) {
        boolean tropicalBiome = biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES);
        float biomeTemp = ((Biome)biome.m_203334_()).m_47505_(pos);
        if (!tropicalBiome && ((Biome)biome.m_203334_()).m_47554_() <= 0.8f && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            switch (subSeason) {
                default: {
                    break;
                }
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.1f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.2f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.4f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_WINTER: 
                case MID_WINTER: 
                case LATE_WINTER: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.8f), (float)-0.5f, (float)2.0f);
                }
            }
        }
        return biomeTemp;
    }

    public static boolean shouldRainInBiomeInSeason(Level world, Holder<Biome> biome) {
        if (biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
        }
        return ((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.RAIN;
    }
}

