/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.NekoConfig;
import com.devbobcorn.nekoration.blocks.DyeableHorizontalBlock;
import com.devbobcorn.nekoration.blocks.states.HorizontalConnection;
import com.devbobcorn.nekoration.blocks.states.ModStateProperties;
import com.devbobcorn.nekoration.common.VanillaCompat;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DyeableHorizontalConnectBlock
extends DyeableHorizontalBlock {
    private static final Map<Direction, VoxelShape> AABBs = DyeableHorizontalConnectBlock.getAABBs(4.0);
    public static final IntegerProperty COLOR = BlockStateProperties.f_61422_;
    public static final EnumProperty<HorizontalConnection> CONNECTION = ModStateProperties.HONRIZONTAL_CONNECTION;
    public final ConnectionType type;
    public final boolean connectOtherVariant;

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> s) {
        s.m_61104_(new Property[]{COLOR, FACING, CONNECTION});
    }

    public DyeableHorizontalConnectBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.type = ConnectionType.TRIPLE;
        this.connectOtherVariant = false;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    public DyeableHorizontalConnectBlock(BlockBehaviour.Properties settings, ConnectionType tp, boolean co) {
        super(settings);
        this.type = tp;
        this.connectOtherVariant = co;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return AABBs.get(state.m_61143_((Property)FACING));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.f_46443_) {
            return VanillaCompat.COLOR_ITEMS.containsKey(itemStack.m_41720_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (VanillaCompat.COLOR_ITEMS.containsKey(itemStack.m_41720_())) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)VanillaCompat.COLOR_ITEMS.get(itemStack.m_41720_())), 3);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean useLeft;
        Level blockView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        NekoConfig.HorConnectionDir config = (NekoConfig.HorConnectionDir)((Object)NekoConfig.SERVER.horConnectionDir.get());
        boolean bl = useLeft = config == NekoConfig.HorConnectionDir.LEFT2RIGHT || config == NekoConfig.HorConnectionDir.BOTH;
        if (config != NekoConfig.HorConnectionDir.NEITHER) {
            boolean connect;
            BlockPos blockPosRef = useLeft ? this.getLeftBlock(blockPos, ctx.m_8125_().m_122424_()) : this.getRightBlock(blockPos, ctx.m_8125_().m_122424_());
            BlockState stateRef = blockView.m_8055_(blockPosRef);
            boolean bl2 = connect = stateRef.m_60734_() instanceof DyeableHorizontalConnectBlock && (this.connectOtherVariant || stateRef.m_60734_() == this);
            if (!connect && config == NekoConfig.HorConnectionDir.BOTH) {
                blockPosRef = this.getRightBlock(blockPos, ctx.m_8125_().m_122424_());
                stateRef = blockView.m_8055_(blockPosRef);
                connect = stateRef.m_60734_() instanceof DyeableHorizontalConnectBlock && (this.connectOtherVariant || stateRef.m_60734_() == this);
                useLeft = false;
            }
            if (connect) {
                if (useLeft) {
                    switch ((HorizontalConnection)((Object)stateRef.m_61143_(CONNECTION))) {
                        case S0: {
                            return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                        }
                        case D0: {
                            return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                        }
                        case T0: {
                            return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                        }
                        case D1: {
                            return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.DOUBLE ? HorizontalConnection.S0 : HorizontalConnection.T2)));
                        }
                        case T1: {
                            return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.T2));
                        }
                        case T2: {
                            return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.BEAM ? HorizontalConnection.T2 : HorizontalConnection.S0)));
                        }
                    }
                    return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.T2));
                }
                switch ((HorizontalConnection)((Object)stateRef.m_61143_(CONNECTION))) {
                    case S0: {
                        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D0));
                    }
                    case D1: {
                        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D0));
                    }
                    case T2: {
                        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D0));
                    }
                    case D0: {
                        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.DOUBLE ? HorizontalConnection.S0 : HorizontalConnection.T0)));
                    }
                    case T1: {
                        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.T0));
                    }
                    case T0: {
                        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.BEAM ? HorizontalConnection.T0 : HorizontalConnection.S0)));
                    }
                }
                return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.T0));
            }
        }
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.S0));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        boolean connect;
        BlockState res = state;
        NekoConfig.HorConnectionDir config = (NekoConfig.HorConnectionDir)((Object)NekoConfig.SERVER.horConnectionDir.get());
        boolean flag1 = direction == this.getRightDir((Direction)state.m_61143_((Property)FACING)) && (config == NekoConfig.HorConnectionDir.LEFT2RIGHT || config == NekoConfig.HorConnectionDir.BOTH);
        boolean flag2 = direction == this.getLeftDir((Direction)state.m_61143_((Property)FACING)) && (config == NekoConfig.HorConnectionDir.RIGHT2LEFT || config == NekoConfig.HorConnectionDir.BOTH);
        boolean bl = connect = flag1 || flag2;
        if (connect && newState.m_60734_() instanceof DyeableHorizontalConnectBlock && (this.connectOtherVariant || newState.m_60734_() == this)) {
            if (flag1) {
                BlockState stateRef = world.m_8055_(this.getLeftBlock(pos, (Direction)state.m_61143_((Property)FACING)));
                switch ((HorizontalConnection)((Object)newState.m_61143_(CONNECTION))) {
                    case D1: {
                        return (BlockState)res.m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D0));
                    }
                    case T1: {
                        return (BlockState)res.m_61124_(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.BEAM && stateRef.m_60734_() instanceof DyeableHorizontalConnectBlock && (this.connectOtherVariant || stateRef.m_60734_() == this) ? HorizontalConnection.T1 : HorizontalConnection.T0)));
                    }
                    case T2: {
                        return (BlockState)res.m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.T1));
                    }
                }
            } else {
                BlockState stateRef = world.m_8055_(this.getRightBlock(pos, (Direction)state.m_61143_((Property)FACING)));
                switch ((HorizontalConnection)((Object)newState.m_61143_(CONNECTION))) {
                    case D0: {
                        return (BlockState)res.m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                    }
                    case T1: {
                        return (BlockState)res.m_61124_(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.BEAM && stateRef.m_60734_() instanceof DyeableHorizontalConnectBlock && (this.connectOtherVariant || stateRef.m_60734_() == this) ? HorizontalConnection.T1 : HorizontalConnection.T2)));
                    }
                    case T0: {
                        return (BlockState)res.m_61124_(CONNECTION, (Comparable)((Object)HorizontalConnection.T1));
                    }
                }
            }
        }
        return res;
    }

    public static enum ConnectionType {
        DOUBLE,
        TRIPLE,
        BEAM;

    }
}

