/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.blocks.DyeableHorizontalWoodenBlock;
import com.devbobcorn.nekoration.blocks.entities.ItemDisplayBlockEntity;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemDisplayBlock
extends DyeableHorizontalWoodenBlock
implements EntityBlock {
    private static final Map<Direction, VoxelShape> AABBs = ItemDisplayBlock.getAABBs(9.0);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;

    public ItemDisplayBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> s) {
        s.m_61104_(new Property[]{COLOR, FACING, OPEN});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ItemDisplayBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return AABBs.get(state.m_61143_((Property)FACING));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof ItemDisplayBlockEntity) {
            player.m_5893_((MenuProvider)((ItemDisplayBlockEntity)tileentity));
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof Container) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileentity));
                world.m_46717_(pos, (Block)this);
            }
            world.m_46747_(pos);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof ItemDisplayBlockEntity) {
            ((ItemDisplayBlockEntity)tileentity).recheckOpen();
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = world.m_7702_(pos)) instanceof ItemDisplayBlockEntity) {
            ((ItemDisplayBlockEntity)tileentity).m_58638_(stack.m_41786_());
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity instanceof MenuProvider ? (MenuProvider)tileentity : null;
    }
}

