/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.event;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.blocks.ModBlocks;
import com.devbobcorn.nekoration.client.gui.widget.FilterButton;
import com.devbobcorn.nekoration.client.gui.widget.IconButton;
import com.devbobcorn.nekoration.items.DyeableBlockItem;
import com.devbobcorn.nekoration.utils.ItemIconHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CreativeInventoryEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("nekoration", "textures/gui/icons.png");
    private static int woodStartIndex;
    private static int decorStartIndex;
    private List<WoodFilter> woodFilters;
    private List<FilterButton> woodButtons;
    private List<DecorFilter> decorFilters;
    private List<FilterButton> decorButtons;
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private boolean viewingWoodTab;
    private boolean viewingDecorTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        this.woodFilters = null;
        this.decorFilters = null;
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            if (this.woodFilters == null) {
                this.compileWoodItems();
            }
            if (this.decorFilters == null) {
                this.compileDecorItems();
            }
            this.viewingWoodTab = false;
            this.viewingDecorTab = false;
            this.guiCenterX = ((CreativeModeInventoryScreen)event.getScreen()).getGuiLeft();
            this.guiCenterY = ((CreativeModeInventoryScreen)event.getScreen()).getGuiTop();
            this.woodButtons = new ArrayList<FilterButton>();
            this.decorButtons = new ArrayList<FilterButton>();
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, (Component)Component.m_237115_((String)"gui.nekoration.button.scroll_up"), button -> {
                if (this.viewingWoodTab) {
                    if (woodStartIndex > 0) {
                        --woodStartIndex;
                    }
                    this.updateWoodTagButtons();
                }
                if (this.viewingDecorTab) {
                    if (decorStartIndex > 0) {
                        --decorStartIndex;
                    }
                    this.updateDecorTagButtons();
                }
            }, ICONS, 64, 0);
            event.addListener((GuiEventListener)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, (Component)Component.m_237115_((String)"gui.nekoration.button.scroll_down"), button -> {
                if (this.viewingWoodTab) {
                    if (woodStartIndex <= this.woodFilters.size() - 4 - 1) {
                        ++woodStartIndex;
                    }
                    this.updateWoodTagButtons();
                }
                if (this.viewingDecorTab) {
                    if (decorStartIndex <= this.decorFilters.size() - 4 - 1) {
                        ++decorStartIndex;
                    }
                    this.updateDecorTagButtons();
                }
            }, ICONS, 80, 0);
            event.addListener((GuiEventListener)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX + 32, this.guiCenterY - 50, (Component)Component.m_237115_((String)"gui.nekoration.button.enable_all"), button -> {
                if (this.viewingWoodTab) {
                    this.woodFilters.forEach(filters -> filters.setEnabled(true));
                    this.woodButtons.forEach(FilterButton::updateState);
                } else if (this.viewingDecorTab) {
                    this.decorFilters.forEach(filters -> filters.setEnabled(true));
                    this.decorButtons.forEach(FilterButton::updateState);
                }
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    if (this.viewingWoodTab) {
                        this.updateWoodItems((CreativeModeInventoryScreen)screen);
                    } else if (this.viewingDecorTab) {
                        this.updateDecorItems((CreativeModeInventoryScreen)screen);
                    }
                }
            }, ICONS, 96, 0);
            event.addListener((GuiEventListener)this.btnEnableAll);
            this.btnDisableAll = new IconButton(this.guiCenterX + 144, this.guiCenterY - 50, (Component)Component.m_237115_((String)"gui.nekoration.button.disable_all"), button -> {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (this.viewingWoodTab) {
                    this.woodFilters.forEach(filters -> filters.setEnabled(false));
                    this.woodButtons.forEach(FilterButton::updateState);
                    if (screen instanceof CreativeModeInventoryScreen) {
                        this.updateWoodItems((CreativeModeInventoryScreen)screen);
                    }
                } else if (this.viewingDecorTab) {
                    this.decorFilters.forEach(filters -> filters.setEnabled(false));
                    this.decorButtons.forEach(FilterButton::updateState);
                    if (screen instanceof CreativeModeInventoryScreen) {
                        this.updateDecorItems((CreativeModeInventoryScreen)screen);
                    }
                }
            }, ICONS, 112, 0);
            event.addListener((GuiEventListener)this.btnDisableAll);
            this.btnScrollUp.f_93624_ = false;
            this.btnScrollDown.f_93624_ = false;
            this.btnEnableAll.f_93624_ = false;
            this.btnDisableAll.f_93624_ = false;
            this.updateWoodTagButtons();
            this.updateDecorTagButtons();
        }
    }

    @SubscribeEvent
    public void onScreenClick(ScreenEvent.MouseButtonPressed.Pre event) {
        if (event.getButton() != 0) {
            return;
        }
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            if (this.viewingWoodTab) {
                for (Button button : this.woodButtons) {
                    if (!button.m_5953_(event.getMouseX(), event.getMouseY()) || !button.m_6375_(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                    return;
                }
            }
            if (this.viewingDecorTab) {
                for (Button button : this.decorButtons) {
                    if (!button.m_5953_(event.getMouseX(), event.getMouseY()) || !button.m_6375_(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPre(ScreenEvent.Render.Pre event) {
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen = (CreativeModeInventoryScreen)event.getScreen();
            this.guiCenterX = screen.getGuiLeft();
            this.guiCenterY = screen.getGuiTop();
        }
    }

    private void updateWoodTagButtons() {
        Button.OnPress pressable = button -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                this.updateWoodItems((CreativeModeInventoryScreen)screen);
            }
        };
        this.woodButtons.clear();
        for (int i = woodStartIndex; i < woodStartIndex + 4 && i < this.woodFilters.size(); ++i) {
            FilterButton button2 = new FilterButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - woodStartIndex) + 10, this.woodFilters.get(i), pressable);
            this.woodButtons.add(button2);
        }
        this.btnScrollUp.f_93623_ = woodStartIndex > 0;
        this.btnScrollDown.f_93623_ = woodStartIndex <= this.woodFilters.size() - 4 - 1;
    }

    private void updateDecorTagButtons() {
        Button.OnPress pressable = button -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                this.updateDecorItems((CreativeModeInventoryScreen)screen);
            }
        };
        this.decorButtons.clear();
        for (int i = decorStartIndex; i < decorStartIndex + 4 && i < this.decorFilters.size(); ++i) {
            FilterButton button2 = new FilterButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - decorStartIndex) + 10, this.decorFilters.get(i), pressable);
            this.decorButtons.add(button2);
        }
        this.btnScrollUp.f_93623_ = decorStartIndex > 0;
        this.btnScrollDown.f_93623_ = decorStartIndex <= this.decorFilters.size() - 4 - 1;
    }

    private void updateWoodItems(CreativeModeInventoryScreen screen) {
        CreativeModeInventoryScreen.ItemPickerMenu container = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
        NonNullList newItems = NonNullList.m_122779_();
        container.f_98639_.clear();
        container.f_98639_.addAll((Collection)newItems);
        container.f_98639_.sort(Comparator.comparingInt(o -> Item.m_41393_((Item)o.m_41720_())));
        container.m_98642_(0.0f);
    }

    private void updateDecorItems(CreativeModeInventoryScreen screen) {
        CreativeModeInventoryScreen.ItemPickerMenu container = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
        NonNullList newItems = NonNullList.m_122779_();
        container.f_98639_.clear();
        container.f_98639_.addAll((Collection)newItems);
        container.f_98639_.sort(Comparator.comparingInt(o -> Item.m_41393_((Item)o.m_41720_())));
        container.m_98642_(0.0f);
    }

    private void compileWoodItems() {
        WoodFilter OAK = new WoodFilter(NekoColors.EnumWoodenColor.LIGHT_GRAY, new ItemStack((ItemLike)Blocks.f_50705_));
        WoodFilter BIRCH = new WoodFilter(NekoColors.EnumWoodenColor.WHITE, new ItemStack((ItemLike)Blocks.f_50742_));
        WoodFilter ACACIA = new WoodFilter(NekoColors.EnumWoodenColor.ORANGE, new ItemStack((ItemLike)Blocks.f_50744_));
        WoodFilter JUNGLE = new WoodFilter(NekoColors.EnumWoodenColor.GRAY, new ItemStack((ItemLike)Blocks.f_50743_));
        WoodFilter SPRUCE = new WoodFilter(NekoColors.EnumWoodenColor.BROWN, new ItemStack((ItemLike)Blocks.f_50741_));
        WoodFilter WARPED = new WoodFilter(NekoColors.EnumWoodenColor.CYAN, new ItemStack((ItemLike)Blocks.f_50656_));
        WoodFilter CRIMSON = new WoodFilter(NekoColors.EnumWoodenColor.MAGENTA, new ItemStack((ItemLike)Blocks.f_50655_));
        WoodFilter DARK_OAK = new WoodFilter(NekoColors.EnumWoodenColor.BLACK, new ItemStack((ItemLike)Blocks.f_50745_));
        WoodFilter MANGROVE = new WoodFilter(NekoColors.EnumWoodenColor.PINK, ItemIconHelper.getCustomBlockItem(10003));
        WoodFilter MAGIC = new WoodFilter(NekoColors.EnumWoodenColor.LIGHT_BLUE, ItemIconHelper.getCustomBlockItem(10001));
        WoodFilter WILLOW = new WoodFilter(NekoColors.EnumWoodenColor.LIME, ItemIconHelper.getCustomBlockItem(10002));
        WoodFilter UMBRAN = new WoodFilter(NekoColors.EnumWoodenColor.PURPLE, ItemIconHelper.getCustomBlockItem(10004));
        WoodFilter CHERRY = new WoodFilter(NekoColors.EnumWoodenColor.RED, ItemIconHelper.getCustomBlockItem(10005));
        WoodFilter PALM = new WoodFilter(NekoColors.EnumWoodenColor.YELLOW, ItemIconHelper.getCustomBlockItem(10006));
        WoodFilter[] vanilla = new WoodFilter[]{OAK, BIRCH, ACACIA, JUNGLE, SPRUCE, WARPED, CRIMSON, DARK_OAK};
        WoodFilter[] extra = new WoodFilter[]{MANGROVE, MAGIC, WILLOW, UMBRAN, CHERRY, PALM};
        this.woodFilters = new ArrayList<WoodFilter>();
        this.woodFilters.addAll(Arrays.asList(vanilla));
        this.woodFilters.addAll(Arrays.asList(extra));
    }

    private void compileDecorItems() {
        ItemStack planterIcon = new ItemStack((ItemLike)ModBlocks.STONE_POT.get());
        DyeableBlockItem.setColor(planterIcon, NekoColors.EnumNekoColor.WHITE);
        ItemStack awningIcon = new ItemStack((ItemLike)ModBlocks.AWNING_STRIPE_SHORT.get());
        DyeableBlockItem.setColor(awningIcon, NekoColors.EnumNekoColor.WHITE);
        ItemStack containerIcon = new ItemStack((ItemLike)ModBlocks.DRAWER_CHEST.get());
        DyeableBlockItem.setColor(containerIcon, NekoColors.EnumNekoColor.ORANGE);
        ItemStack miscIcon = new ItemStack((ItemLike)ModBlocks.CANDLE_HOLDER_GOLD.get());
        DyeableBlockItem.setColor(miscIcon, NekoColors.EnumNekoColor.WHITE);
        DecorFilter PLANTER = new DecorFilter(EnumDecorType.PLANTER, planterIcon);
        DecorFilter AWNING = new DecorFilter(EnumDecorType.AWNING, awningIcon);
        DecorFilter FURNITURE = new DecorFilter(EnumDecorType.FURNITURE, new ItemStack((ItemLike)ModBlocks.SPRUCE_TABLE.get()));
        DecorFilter CONTAINER = new DecorFilter(EnumDecorType.CONTAINER, containerIcon);
        DecorFilter MISC = new DecorFilter(EnumDecorType.MISC, miscIcon);
        this.decorFilters = new ArrayList<DecorFilter>();
        this.decorFilters.addAll(Arrays.asList(PLANTER, AWNING, FURNITURE, CONTAINER, MISC));
    }

    public static interface Filter {
        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public Component getName();

        public ItemStack getIcon();
    }

    public static class WoodFilter
    implements Filter {
        private final NekoColors.EnumWoodenColor wood;
        private final Component name;
        private final ItemStack icon;
        private boolean enabled = true;

        public WoodFilter(NekoColors.EnumWoodenColor type, ItemStack icon) {
            this.wood = type;
            this.name = Component.m_237115_((String)String.format("color.wooden.%s", type.m_7912_().replace("/", ".")));
            this.icon = icon;
        }

        public NekoColors.EnumWoodenColor getWood() {
            return this.wood;
        }

        @Override
        public ItemStack getIcon() {
            return this.icon;
        }

        @Override
        public Component getName() {
            return this.name;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class DecorFilter
    implements Filter {
        private final EnumDecorType decor;
        private final Component name;
        private final ItemStack icon;
        private boolean enabled = true;

        public DecorFilter(EnumDecorType type, ItemStack icon) {
            this.decor = type;
            this.name = Component.m_237115_((String)String.format("decortype.%s", type.m_7912_().replace("/", ".")));
            this.icon = icon;
        }

        public EnumDecorType getDecor() {
            return this.decor;
        }

        @Override
        public ItemStack getIcon() {
            return this.icon;
        }

        @Override
        public Component getName() {
            return this.name;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static enum EnumDecorType implements StringRepresentable
    {
        PLANTER("planter"),
        AWNING("awning"),
        FURNITURE("furniture"),
        CONTAINER("container"),
        MISC("misc");

        private final String name;

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        private EnumDecorType(String i_name) {
            this.name = i_name;
        }
    }
}

