/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.gui.screen;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.NekoConfig;
import com.devbobcorn.nekoration.client.gui.widget.IconButton;
import com.devbobcorn.nekoration.entities.PaintingData;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.devbobcorn.nekoration.items.PaletteItem;
import com.devbobcorn.nekoration.network.C2SUpdatePaintingData;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.utils.URLHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PaintingScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("nekoration", "textures/gui/painting.png");
    public static final ResourceLocation ICONS = new ResourceLocation("nekoration", "textures/gui/icons.png");
    public static final int PAINTING_LEFT = 9;
    public static final int PAINTING_TOP = 38;
    public static final int PAINTING_WIDTH = 225;
    public static final int PAINTING_HEIGHT = 145;
    public static final int OPACITY_LEFT = 241;
    public static final int OPACITY_TOP = 38;
    public static final int OPACITY_WIDTH = 6;
    public static final int OPACITY_HEIGHT = 145;
    public static final int TOOLS_LEFT = 148;
    public static final int TOOLS_TOP = 13;
    public static final int TOOLS_NUM = 4;
    public static final int white = -1;
    public static final int black = -16777216;
    private final int imageWidth = 256;
    private final int imageHeight = 192;
    private final Deque<int[]> history = new LinkedList<int[]>();
    private final Deque<int[]> future = new LinkedList<int[]>();
    private int leftPos;
    private int topPos;
    private int entityId;
    private Color[] colors;
    private byte activeSlot;
    private int opacity = 255;
    private int opacityPos;
    private byte activeTool = 0;
    private static final int[] toolParams = new int[]{1, 1, 2, 5};
    private static final int[] MAX_PARAMS = new int[]{10, 10, 16, 99};
    public boolean renderDebugText = false;
    private final PaintingData paintingData;
    private final short paintingWidth;
    private final short paintingHeight;
    private final int oldHash;
    private EditBox nameInput;
    private boolean nameError = false;
    private final IconButton[] buttons = new IconButton[5];
    private static double hor = 0.0;
    private static double ver = 0.0;
    private static int pixsize = 8;
    private static int lastEdited = 0;
    private static int renderTime = 0;
    private static final int TIPS = 3;
    private final Component[] tipMessages = new Component[3];
    private static final String[] buttonKeys = new String[]{"save_painting", "save_painting_content", "load_image", "clear", "round_brush", "square_brush", "transp_add_up", "transp_overwrite"};
    private final Component[] buttonMessages = new Component[buttonKeys.length];
    private final Component[] paramMessages = new Component[4];
    private static int stepLimit;
    private static boolean roundBrush;
    private static boolean transBlend;
    private String debugText = "Ceci n'est pas une ligne de texte.";

    public PaintingScreen(int pt) {
        this(pt, 0, PaletteItem.DEFAULT_COLOR_SET);
    }

    public PaintingScreen(int pt, byte active, Color[] paletteColors) {
        super(Component.m_130674_((String)"PAINTING"));
        int idx;
        this.opacityPos = this.topPos + 38;
        this.activeSlot = active;
        this.colors = paletteColors;
        this.entityId = pt;
        PaintingEntity painting = (PaintingEntity)Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
        this.paintingData = painting.data;
        this.paintingWidth = painting.data.getWidth();
        this.paintingHeight = painting.data.getHeight();
        this.paintingData.imageReady = false;
        this.oldHash = this.paintingData.getPaintingHash();
        if (this.oldHash != lastEdited) {
            ver = 0.0;
            hor = 0.0;
            pixsize = 8;
        }
        this.tipMessages[0] = Component.m_237110_((String)"gui.nekoration.message.press_key_debug_info", (Object[])new Object[]{"'F1'"});
        this.tipMessages[1] = Component.m_237110_((String)"gui.nekoration.message.press_key_undo_redo", (Object[])new Object[]{"'Z'/'X'"});
        this.tipMessages[2] = Component.m_237110_((String)"gui.nekoration.message.press_key_change_tool", (Object[])new Object[]{"'W'"});
        for (idx = 0; idx < buttonKeys.length; ++idx) {
            this.buttonMessages[idx] = Component.m_237115_((String)("gui.nekoration.button." + buttonKeys[idx]));
        }
        for (idx = 0; idx < 4; ++idx) {
            this.paramMessages[idx] = Component.m_237110_((String)"gui.nekoration.message.scroll_change", (Object[])new Object[]{Component.m_237115_((String)("gui.nekoration.paint.tool_param" + idx)).getString()});
        }
        this.history.clear();
        this.future.clear();
        stepLimit = (Integer)NekoConfig.CLIENT.maxUndoLimit.get();
    }

    private String[] getFileLocation() {
        String file = this.nameInput.m_94155_().trim();
        if (file.equals("")) {
            return new String[]{"nekopaint", String.valueOf(this.paintingData.getPaintingHash())};
        }
        int slashIdx = Math.max(file.lastIndexOf("/"), file.lastIndexOf("\\"));
        if (slashIdx == -1) {
            return new String[]{"nekopaint", file};
        }
        return new String[]{"nekopaint/" + file.substring(0, slashIdx + 1), file.substring(slashIdx + 1)};
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.nameInput = new EditBox(this.f_96547_, this.leftPos + 57, this.topPos - 18, 121, 16, (Component)Component.m_237115_((String)"gui.nekoration.color"));
        this.nameInput.m_94199_(256);
        this.nameInput.m_94151_(input -> {
            if (this.nameError) {
                this.nameInput.m_94202_(0xFFFFFF);
                this.nameError = false;
                this.buttons[2].setIcon(ICONS, 32, 16);
                this.buttons[2].m_93666_(this.buttonMessages[2]);
            }
        });
        this.buttons[0] = new IconButton(this.leftPos + 180, this.topPos - 20, this.buttonMessages[0], button -> {
            try {
                String[] location = this.getFileLocation();
                this.paintingData.save(location[0], location[1], true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, ICONS, 0, 16);
        this.buttons[1] = new IconButton(this.leftPos + 200, this.topPos - 20, this.buttonMessages[1], button -> {
            try {
                String[] location = this.getFileLocation();
                this.paintingData.save(location[0], location[1], false, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, ICONS, 16, 16);
        this.buttons[2] = new IconButton(this.leftPos + 220, this.topPos - 20, this.buttonMessages[2], button -> {
            if (this.nameError) {
                this.nameInput.m_94144_("");
                this.nameInput.m_94202_(0xFFFFFF);
                this.nameError = false;
                this.buttons[2].setIcon(ICONS, 32, 16);
                this.buttons[2].m_93666_(this.buttonMessages[2]);
                return;
            }
            if (this.nameInput.m_94155_().trim().equals("")) {
                this.nameInput.m_94144_("Input the name here...");
                this.nameError = true;
            } else if (URLHelper.isURL(this.nameInput.m_94155_().split(">")[0].trim())) {
                System.out.println("Looks like a url...");
                this.nameError = !this.paintingData.load("<url>", this.nameInput.m_94155_().trim());
            } else {
                String[] location = this.getFileLocation();
                boolean bl = this.nameError = !this.paintingData.load(location[0], location[1]);
            }
            if (this.nameError) {
                this.nameInput.m_94202_(0xFF0000);
                this.buttons[2].setIcon(ICONS, 32, 0);
                this.buttons[2].m_93666_(this.buttonMessages[3]);
            }
        }, ICONS, 32, 16);
        this.buttons[3] = new IconButton(this.leftPos + 15, this.topPos - 20, roundBrush ? this.buttonMessages[4] : this.buttonMessages[5], button -> {
            roundBrush = !roundBrush;
            this.buttons[3].setIcon(ICONS, roundBrush ? 48 : 64, 16);
            this.buttons[3].m_93666_(roundBrush ? this.buttonMessages[4] : this.buttonMessages[5]);
        }, ICONS, roundBrush ? 48 : 64, 16);
        this.buttons[4] = new IconButton(this.leftPos + 35, this.topPos - 20, transBlend ? this.buttonMessages[6] : this.buttonMessages[7], button -> {
            transBlend = !transBlend;
            this.buttons[4].setIcon(ICONS, transBlend ? 80 : 96, 16);
            this.buttons[4].m_93666_(transBlend ? this.buttonMessages[6] : this.buttonMessages[7]);
        }, ICONS, transBlend ? 80 : 96, 16);
        this.m_7787_((GuiEventListener)this.nameInput);
        for (int btn = 0; btn < 5; ++btn) {
            this.m_7787_((GuiEventListener)this.buttons[btn]);
        }
        renderTime = 40;
    }

    public void m_86600_() {
        this.nameInput.m_94120_();
    }

    public void m_7379_() {
        try {
            if (this.oldHash != this.paintingData.getPaintingHash()) {
                this.paintingData.clearCache(this.oldHash);
                byte blocW = (byte)(this.paintingWidth / 16);
                byte blocH = (byte)(this.paintingHeight / 16);
                int partCount = 0;
                for (byte blocX = 0; blocX < blocW; blocX = (byte)(blocX + 3)) {
                    for (byte blocY = 0; blocY < blocH; blocY = (byte)(blocY + 3)) {
                        byte ptW = (byte)Math.min(blocW - blocX, 3);
                        byte ptH = (byte)Math.min(blocH - blocY, 3);
                        int[] partPixels = new int[ptW * 16 * ptH * 16];
                        for (int i = 0; i < ptW * 16; ++i) {
                            for (int j = 0; j < ptH * 16; ++j) {
                                int x = blocX * 16 + i;
                                int y = blocY * 16 + j;
                                partPixels[j * ptW * 16 + i] = this.paintingData.getPixelAt(x, y);
                            }
                        }
                        System.out.printf("[%s] Sending Painting(%s) Part: %s, %s (%s x %s)", partCount, this.paintingData.getPaintingHash(), blocX / 3, blocY / 3, ptW, ptH);
                        C2SUpdatePaintingData packet = new C2SUpdatePaintingData(this.entityId, (byte)(blocX / 3), (byte)(blocY / 3), ptW, ptH, partPixels, this.paintingData.getPaintingHash());
                        ModPacketHandler.CHANNEL.sendToServer((Object)packet);
                        ++partCount;
                    }
                }
                if (((Boolean)NekoConfig.CLIENT.useImageRendering.get()).booleanValue()) {
                    this.paintingData.cache();
                }
            } else {
                this.paintingData.imageReady = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        lastEdited = this.paintingData.getPaintingHash();
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 290) {
            this.renderDebugText = !this.renderDebugText;
            return true;
        }
        if (this.nameInput.m_93696_()) {
            return super.m_7933_(keyCode, scanCode, modifier);
        }
        if (keyCode == 87) {
            this.activeTool = (byte)((this.activeTool + 1) % 4);
            return true;
        }
        if (keyCode == 90) {
            int[] futureCopy = Arrays.copyOf(this.paintingData.getPixels(), this.paintingData.getPixels().length);
            int[] target = this.history.pollFirst();
            if (target != null) {
                this.paintingData.setPixels(target);
                this.future.offerFirst(futureCopy);
                if (this.future.size() > stepLimit) {
                    this.future.pollLast();
                }
            }
            return true;
        }
        if (keyCode == 88) {
            int[] pastCopy = Arrays.copyOf(this.paintingData.getPixels(), this.paintingData.getPixels().length);
            int[] target = this.future.pollFirst();
            if (target != null) {
                this.paintingData.setPixels(target);
                this.history.offerFirst(pastCopy);
                if (this.history.size() > stepLimit) {
                    this.history.pollLast();
                }
            }
            return true;
        }
        if (keyCode == 256) {
            Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_).m_6915_();
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    public void m_86412_(PoseStack stack, int x, int y, float partialTicks) {
        int i = this.leftPos;
        int j = this.topPos;
        this.m_93179_(stack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        for (int idx = 0; idx < 6; ++idx) {
            RenderSystem.m_157429_((float)((float)this.colors[idx].getRed() / 255.0f), (float)((float)this.colors[idx].getGreen() / 255.0f), (float)((float)this.colors[idx].getBlue() / 255.0f), (float)1.0f);
            this.m_93228_(stack, i + 34 + 18 * idx, j + 13, 16, 224, 16, 16);
            if (idx != this.activeSlot) continue;
            this.m_93228_(stack, i + 8, j + 13, 16, 224, 16, 16);
        }
        try {
            for (short posi = 0; posi < this.paintingWidth; posi = (short)(posi + 1)) {
                if (hor + (double)((posi + 1) * pixsize) < 0.0 || hor + (double)(posi * pixsize) > 225.0) continue;
                for (short posj = 0; posj < this.paintingHeight; posj = (short)(posj + 1)) {
                    if (ver + (double)((posj + 1) * pixsize) < 0.0 || ver + (double)(posj * pixsize) > 145.0) continue;
                    Color color = NekoColors.getRGBColor(this.paintingData.getCompositeAt(posi, posj));
                    RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                    this.m_93228_(stack, i + 9 + (int)hor + posi * pixsize, j + 38 + (int)ver + posj * pixsize, 16, 224, pixsize, pixsize);
                }
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception color) {
            // empty catch block
        }
        this.renderBg(stack, partialTicks, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(stack, i + 34 + 18 * this.activeSlot, j + 13, 16, 208, 16, 16);
        this.m_93179_(stack, i + 241, j + 38, i + 241 + 6, j + 38 + 145, this.colors[this.activeSlot].getRGB(), this.colors[this.activeSlot].getRGB() & 0xFFFFFF);
        if (this.opacityPos >= 0) {
            this.m_93228_(stack, i + 241 - 1, this.opacityPos + this.topPos - 1, 0, 240, 8, 4);
        }
        this.m_93228_(stack, i + 148 + this.activeTool * 17, j + 13, 32 + this.activeTool * 16, 208, 16, 16);
        this.nameInput.m_86412_(stack, x, y, partialTicks);
        for (int btn = 0; btn < 5; ++btn) {
            this.buttons[btn].m_86412_(stack, x, y, partialTicks);
        }
        for (int tip = 0; tip < 5; ++tip) {
            if (!this.buttons[tip].m_5953_(x, y)) continue;
            this.m_96602_(stack, this.buttons[tip].m_6035_(), x, y);
        }
        stack.m_252880_((float)(i + 221), (float)(j + 17), 0.0f);
        this.f_96547_.m_92883_(stack, "<" + String.format("%02d", toolParams[this.activeTool]) + ">", 1.0f, 1.0f, 0xFFFFFF);
        stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        stack.m_252880_(-12.0f, -44.0f, 0.0f);
        if (this.isOnToolParam(x, y)) {
            this.f_96547_.m_92889_(stack, this.paramMessages[this.activeTool], 1.0f, 1.0f, 0xFFFFFF);
        } else if (this.renderDebugText) {
            this.f_96547_.m_92883_(stack, this.debugText, 1.0f, 1.0f, 0xFFFFFF);
        } else {
            ++renderTime;
            int ap = (renderTime %= 900) % 300;
            ap = ap == 0 ? 5 : (ap < 20 ? (ap *= 8) : (ap > 280 ? (300 - ap) * 8 : 160));
            this.f_96547_.m_92889_(stack, this.tipMessages[renderTime / 300], 1.0f, 1.0f, (ap << 24) + 0xFF0000 + 65280 + 255);
        }
    }

    protected void renderBg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(stack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean m_6375_(double x, double y, int type) {
        if (type == 0 && !this.updateActiveSlot(x, y)) {
            if (this.isOnOpacityPicker(x, y)) {
                this.getOpacity(x, y);
                this.debugText = "Opacity: " + this.opacity;
            } else if (this.isOnPainting(x, y)) {
                this.history.offerFirst(Arrays.copyOf(this.paintingData.getPixels(), this.paintingData.getPixels().length));
                if (this.history.size() > stepLimit) {
                    this.history.pollLast();
                }
                this.future.clear();
                this.useTool(x, y);
            } else {
                for (int idx = 0; idx < 4; idx = (int)((byte)(idx + 1))) {
                    if (!this.isOn(x - 148.0 - (double)(idx * 17), y - 13.0, 16.0, 16.0)) continue;
                    this.activeTool = (byte)idx;
                }
            }
        }
        return super.m_6375_(x, y, type);
    }

    private boolean isOn(double x, double y, double w, double h) {
        double dx = x - (double)this.leftPos;
        double dy = y - (double)this.topPos;
        return dx >= 0.0 && dy >= 0.0 && dx <= w && dy <= h;
    }

    public boolean m_7979_(double x, double y, int type, double dx, double dy) {
        if (type == 0) {
            if (this.isOnPainting(x, y)) {
                this.useTool(x, y);
            } else if (this.isOnOpacityPicker(x, y)) {
                this.getOpacity(x, y);
                this.debugText = "Opacity: " + this.opacity;
            }
        } else if (type == 2) {
            hor += dx;
            ver += dy;
            this.debugText = "Position: " + x + ", " + y + " -> " + dx + ", " + dy;
        }
        return super.m_7979_(x, y, type, dx, dy);
    }

    private void useTool(double x, double y) {
        double areax = x - (double)this.leftPos - 9.0;
        double areay = y - (double)this.topPos - 38.0;
        double pixX = (areax - hor) / (double)pixsize;
        double pixY = (areay - ver) / (double)pixsize;
        switch (this.activeTool) {
            case 0: {
                this.debugText = String.format("Stroke: [%.2f, %.2f]", pixX, pixY);
                this.usePencil(pixX, pixY);
                break;
            }
            case 1: {
                this.debugText = String.format("Draw: [%.2f, %.2f]", pixX, pixY);
                this.usePen(pixX, pixY);
                break;
            }
            case 2: {
                this.debugText = String.format("Erase: [%.2f, %.2f]", pixX, pixY);
                this.useEraser(pixX, pixY);
                break;
            }
            case 3: {
                this.debugText = String.format("Fill: [%.2f, %.2f]", pixX, pixY);
                this.useBucket(pixX, pixY);
            }
        }
    }

    private void usePencil(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        for (int i = -toolParams[0]; i <= toolParams[0]; ++i) {
            for (int j = -toolParams[0]; j <= toolParams[0]; ++j) {
                if (roundBrush && i * i + j * j > toolParams[0] * toolParams[0]) continue;
                this.paintingData.setPixel(pixX + i, pixY + j, (this.opacity << 24) + this.colors[this.activeSlot].getRGB(), transBlend);
            }
        }
    }

    private void usePen(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        for (int i = -toolParams[1]; i <= toolParams[1]; ++i) {
            for (int j = -toolParams[1]; j <= toolParams[1]; ++j) {
                float frct;
                if (roundBrush) {
                    int dis2 = i * i + j * j;
                    if (dis2 > toolParams[1] * toolParams[1]) continue;
                    frct = 1.0f - Mth.m_14036_((float)(Mth.m_14116_((float)dis2) / ((float)toolParams[1] + 0.1f)), (float)0.0f, (float)1.0f);
                    this.paintingData.setPixel(pixX + i, pixY + j, ((int)(frct * (float)this.opacity) << 24) + this.colors[this.activeSlot].getRGB(), transBlend);
                    continue;
                }
                int dis = Math.max(Math.abs(i), Math.abs(j));
                frct = 1.0f - Mth.m_14036_((float)((float)dis / ((float)toolParams[1] + 0.1f)), (float)0.0f, (float)1.0f);
                this.paintingData.setPixel(pixX + i, pixY + j, ((int)(frct * (float)this.opacity) << 24) + this.colors[this.activeSlot].getRGB(), transBlend);
            }
        }
    }

    private void useBucket(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        this.paintingData.fill(pixX, pixY, this.colors[this.activeSlot].getRGB(), this.opacity, toolParams[3], transBlend);
    }

    private void useEraser(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        for (int i = -toolParams[2]; i <= toolParams[2]; ++i) {
            for (int j = -toolParams[2]; j <= toolParams[2]; ++j) {
                if (roundBrush && i * i + j * j > toolParams[2] * toolParams[2]) continue;
                this.paintingData.clearPixel(pixX + i, pixY + j);
            }
        }
    }

    public boolean m_6050_(double x, double y, double d2) {
        if (this.isOnToolParam(x, y)) {
            this.debugText = "Param: " + x + ", " + y + ", " + d2;
            byte by = this.activeTool;
            toolParams[by] = (int)((double)toolParams[by] + d2);
            PaintingScreen.toolParams[this.activeTool] = Mth.m_14045_((int)toolParams[this.activeTool], (int)0, (int)MAX_PARAMS[this.activeTool]);
        } else {
            this.debugText = "Scale: " + x + ", " + y + ", " + d2;
            double areax = x - (double)this.leftPos - 9.0;
            double areay = y - (double)this.topPos - 38.0;
            double oldpixsize = pixsize;
            pixsize = (int)((double)pixsize + d2);
            pixsize = Math.min(Math.max(1, pixsize), 10);
            double scale = (double)pixsize / oldpixsize;
            double dx = (areax - hor) * scale;
            double dy = (areay - ver) * scale;
            hor = areax - dx;
            ver = areay - dy;
        }
        return super.m_6050_(x, y, d2);
    }

    private boolean isOnPainting(double x, double y) {
        double dx = x - (double)this.leftPos - 9.0;
        double dy = y - (double)this.topPos - 38.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 225.0 && dy <= 145.0;
    }

    private boolean updateActiveSlot(double x, double y) {
        for (byte idx = 0; idx < 6; ++idx) {
            int l = this.leftPos + 34 + 18 * idx;
            int r = l + 16;
            int t = this.topPos + 13;
            int b = t + 16;
            if (!(x >= (double)l) || !(x <= (double)r) || !(y >= (double)t) || !(y <= (double)b) || this.activeSlot == idx) continue;
            this.activeSlot = idx;
            return true;
        }
        return false;
    }

    private boolean isOnToolParam(double x, double y) {
        return this.isOn(x - 216.0, y - 13.0, 33.0, 16.0);
    }

    private boolean isOnOpacityPicker(double x, double y) {
        double dx = x - (double)this.leftPos - 241.0;
        double dy = y - (double)this.topPos - 38.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 6.0 && dy <= 145.0;
    }

    private void getOpacity(double x, double y) {
        this.opacity = (int)((1.0 - (y - (double)this.topPos - 38.0) / 145.0) * 255.0);
        this.opacityPos = (int)y - this.topPos;
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        roundBrush = true;
        transBlend = true;
    }
}

