/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.gui.screen;

import com.devbobcorn.nekoration.network.C2SUpdatePaintingSize;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintingSizeScreen
extends Screen {
    public static final ResourceLocation PAINTING_SIZE = new ResourceLocation("nekoration", "textures/gui/painting_size.png");
    public static final int BACKGROUND_WIDTH = 124;
    public static final int BACKGROUND_HEIGHT = 146;
    public static final int GRID_LEFT = 8;
    public static final int GRID_TOP = 30;
    public static boolean useLargeSize = false;
    public static int slotLen = 18;
    public static int slotNum = 6;
    private int leftPos;
    private int topPos;
    private InteractionHand hand;
    private int stackCount;
    private short pickedWidth;
    private short pickedHeight;
    private Component tipMessage;
    private Component[] warningMessages = new Component[2];
    private int warningOpacity = 0;

    public PaintingSizeScreen(InteractionHand hand, int count) {
        super(Component.m_130674_((String)"PAINTING_SIZE"));
        this.hand = hand;
        this.stackCount = count;
        this.tipMessage = Component.m_237110_((String)"gui.nekoration.message.press_key_change_grid", (Object[])new Object[]{"'E'"});
        this.warningMessages[0] = Component.m_237115_((String)"gui.nekoration.message.painting_size_warning");
        this.warningMessages[1] = Component.m_237115_((String)"gui.nekoration.message.painting_size_warning_help");
    }

    protected void m_7856_() {
        super.m_7856_();
        this.pickedWidth = (short)(slotNum / 2);
        this.pickedHeight = (short)(slotNum / 2);
        this.leftPos = (this.f_96543_ - 124) / 2;
        this.topPos = (this.f_96544_ - 146) / 2;
    }

    public void m_86412_(PoseStack stack, int x, int y, float partialTicks) {
        stack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PAINTING_SIZE);
        int i = this.leftPos;
        int j = this.topPos;
        this.m_93228_(stack, i, j, 0, 0, 124, 146);
        stack.m_85849_();
        for (int ix = 0; ix < slotNum; ++ix) {
            for (int iy = 0; iy < slotNum; ++iy) {
                this.m_93228_(stack, i + 8 + ix * slotLen, j + 30 + iy * slotLen, ix < this.pickedWidth && iy < this.pickedHeight ? 18 : 0, useLargeSize ? 178 : 160, 18, 18);
            }
        }
        PaintingSizeScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237110_((String)"gui.nekoration.message.size", (Object[])new Object[]{this.pickedWidth, this.pickedHeight}), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 66), (int)-1);
        if (this.pickedHeight > 6 || this.pickedWidth > 6) {
            if (this.warningOpacity < 210) {
                this.warningOpacity += 30;
            }
        } else if (this.warningOpacity > 0) {
            this.warningOpacity -= 30;
        }
        if (this.warningOpacity > 0) {
            PaintingSizeScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.warningMessages[0], (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 44), (int)((this.warningOpacity << 24) + 0xFF0000 + 17920 + 70));
            PaintingSizeScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.warningMessages[1], (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 34), (int)((this.warningOpacity << 24) + 0xDC0000 + 7680 + 250));
        }
        stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        stack.m_252880_((float)j, (float)(-i - 136), 0.0f);
        this.f_96547_.m_92889_(stack, this.tipMessage, 1.0f, 1.0f, -1761607681);
    }

    public void m_94757_(double x, double y) {
        double gridx = x - (double)this.leftPos - 8.0;
        double gridy = y - (double)this.topPos - 30.0;
        if (gridx < 0.0 || gridy < 0.0 || gridx > 108.0 || gridy > 108.0) {
            return;
        }
        this.pickedWidth = (short)Math.min(Math.max((int)Math.ceil(gridx / (double)slotLen), 1), slotNum);
        this.pickedHeight = (short)Math.min(Math.max((int)Math.ceil(gridy / (double)slotLen), 1), slotNum);
    }

    public boolean m_6375_(double x, double y, int type) {
        double gridx = x - (double)this.leftPos - 8.0;
        double gridy = y - (double)this.topPos - 30.0;
        if (gridx < 0.0 || gridy < 0.0 || gridx > 108.0 || gridy > 108.0) {
            return false;
        }
        this.pickedWidth = (short)Math.min(Math.max((int)Math.ceil(gridx / (double)slotLen), 1), slotNum);
        this.pickedHeight = (short)Math.min(Math.max((int)Math.ceil(gridy / (double)slotLen), 1), slotNum);
        C2SUpdatePaintingSize packet = new C2SUpdatePaintingSize(this.hand, this.pickedWidth, this.pickedHeight, this.stackCount);
        ModPacketHandler.CHANNEL.sendToServer((Object)packet);
        this.f_96541_.m_91152_((Screen)null);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 69) {
            useLargeSize = !useLargeSize;
            slotLen = useLargeSize ? 6 : 18;
            slotNum = useLargeSize ? 18 : 6;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    public boolean m_7043_() {
        return false;
    }
}

