/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.gui.screen;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.network.C2SUpdatePaletteData;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.utils.VoxelShapeHighlighter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class PaletteScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("nekoration", "textures/gui/palette.png");
    public static final int COLORMAP_LEFT = 9;
    public static final int COLORMAP_TOP = 32;
    public static final int COLORMAP_WIDTH = 128;
    public static final int COLORMAP_HEIGHT = 128;
    public static final int HUE_LEFT = 141;
    public static final int HUE_TOP = 32;
    public static final int HUE_WIDTH = 6;
    public static final int HUE_HEIGHT = 128;
    public static final int white = -1;
    public static final int black = -16777216;
    private final int imageWidth = 156;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private Color colorMapColor = Color.RED;
    private Color[] colors = new Color[6];
    private byte activeSlot = 0;
    private int huePos = -1;
    private int[] colorPos = new int[]{-1, -1};
    private InteractionHand hand;
    public boolean renderColorText = false;
    private Component tipMessage;

    public PaletteScreen(InteractionHand hand, byte active, Color[] oldColors) {
        super(Component.m_130674_((String)"PALETTE"));
        this.hand = hand;
        this.colors = oldColors;
        this.tipMessage = Component.m_237110_((String)"gui.nekoration.message.press_key_color_info", (Object[])new Object[]{"'E'"});
        this.setActiveSlot(active);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void m_7379_() {
        try {
            VoxelShapeHighlighter.PaletteColor = this.colors[this.activeSlot];
            int[] cls = new int[6];
            for (int idx = 0; idx < 6; ++idx) {
                cls[idx] = this.colors[idx].getRGB();
            }
            C2SUpdatePaletteData packet = new C2SUpdatePaletteData(this.hand, this.activeSlot, cls);
            ModPacketHandler.CHANNEL.sendToServer((Object)packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 69) {
            this.renderColorText = !this.renderColorText;
            return true;
        }
        if (keyCode == 256) {
            Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_).m_6915_();
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    public void m_86412_(PoseStack stack, int x, int y, float partialTicks) {
        int i = this.leftPos;
        int j = this.topPos;
        this.m_93179_(stack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        for (int idx = 0; idx < 6; ++idx) {
            RenderSystem.m_157429_((float)((float)this.colors[idx].getRed() / 255.0f), (float)((float)this.colors[idx].getGreen() / 255.0f), (float)((float)this.colors[idx].getBlue() / 255.0f), (float)1.0f);
            this.m_93228_(stack, i + 8 + 18 * idx + (idx > 2 ? 34 : 0), j + 13, 172, 32, 16, 16);
            if (idx != this.activeSlot) continue;
            this.m_93228_(stack, i + 70, j + 13, 172, 32, 16, 16);
        }
        this.renderBg(stack, partialTicks, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(stack, i + 8 + 18 * this.activeSlot + (this.activeSlot > 2 ? 34 : 0), j + 13, 172, 16, 16, 16);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        stack.m_252880_((float)(j + 32), (float)(-i - 137), 0.0f);
        this.m_93179_(stack, 0, 0, 128, 128, this.colorMapColor.getRGB(), -1);
        stack.m_85849_();
        this.m_93179_(stack, i + 9, j + 32, i + 9 + 128, j + 32 + 128, 0, -16777216);
        if (this.huePos >= 0) {
            this.m_93228_(stack, i + 141 - 1, this.huePos + this.topPos - 1, 156, 48, 8, 4);
        }
        if (this.colorPos[0] >= 0) {
            this.m_93228_(stack, this.leftPos + this.colorPos[0] - 2, this.topPos + this.colorPos[1] - 2, 172, 48, 4, 4);
        }
        stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        stack.m_252880_((float)j, (float)(-i - 167), 0.0f);
        if (this.renderColorText) {
            this.f_96547_.m_92889_(stack, (Component)Component.m_237110_((String)"gui.nekoration.message.color_info", (Object[])new Object[]{this.colors[this.activeSlot].getRGB(), this.colors[this.activeSlot].getRed(), this.colors[this.activeSlot].getGreen(), this.colors[this.activeSlot].getBlue()}), 1.0f, 1.0f, this.colors[this.activeSlot].getRGB());
        } else {
            this.f_96547_.m_92889_(stack, this.tipMessage, 1.0f, 1.0f, -1761607681);
        }
    }

    protected void renderBg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int edgeSpacingX = (this.f_96543_ - this.imageWidth) / 2;
        int edgeSpacingY = (this.f_96544_ - this.imageHeight) / 2;
        this.m_93228_(stack, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean m_6375_(double x, double y, int type) {
        if (type == 0 && !this.updateActiveSlot(x, y)) {
            if (this.isOnColorMap(x, y)) {
                this.getColor(x, y);
            }
            if (this.isOnHuePicker(x, y)) {
                this.getHue(x, y);
            }
        }
        return super.m_6375_(x, y, type);
    }

    public boolean m_7979_(double x, double y, int type, double dx, double dy) {
        if (type == 0) {
            if (this.isOnColorMap(x, y)) {
                this.getColor(x, y);
            }
            if (this.isOnHuePicker(x, y)) {
                this.getHue(x, y);
            }
        }
        return super.m_7979_(x, y, type, dx, dy);
    }

    private boolean isOnColorMap(double x, double y) {
        double dx = x - (double)this.leftPos - 9.0;
        double dy = y - (double)this.topPos - 32.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 128.0 && dy <= 128.0;
    }

    private boolean updateActiveSlot(double x, double y) {
        for (byte idx = 0; idx < 6; ++idx) {
            int l = this.leftPos + 8 + 18 * idx + (idx > 2 ? 34 : 0);
            int r = l + 16;
            int t = this.topPos + 13;
            int b = t + 16;
            if (!(x >= (double)l) || !(x <= (double)r) || !(y >= (double)t) || !(y <= (double)b) || this.activeSlot == idx) continue;
            this.setActiveSlot(idx);
            return true;
        }
        return false;
    }

    private void setActiveSlot(int slot) {
        this.activeSlot = (byte)slot;
        Color nw = this.colors[slot];
        float[] fl = Color.RGBtoHSB(nw.getRed(), nw.getGreen(), nw.getBlue(), null);
        this.huePos = 32 + (int)((1.0f - fl[0]) * 128.0f);
        this.colorMapColor = Color.getHSBColor(fl[0], 1.0f, 1.0f);
    }

    private void getColor(double x, double y) {
        double xi = (x - (double)this.leftPos - 9.0) / 128.0;
        double yi = (y - (double)this.topPos - 32.0) / 128.0;
        if (xi >= 0.0 && xi <= 1.0 && yi >= 0.0 && yi <= 1.0) {
            Color c1 = NekoColors.getRGBColorBetween(xi, Color.WHITE, this.colorMapColor);
            if (this.activeSlot >= 0 && this.activeSlot < this.colors.length) {
                this.colors[this.activeSlot] = NekoColors.getRGBColorBetween(yi, c1, Color.BLACK);
                this.colorPos[0] = (int)x - this.leftPos;
                this.colorPos[1] = (int)y - this.topPos;
            }
        }
    }

    private void updateColor() {
        double xi = (double)(this.colorPos[0] - 9) / 128.0;
        double yi = (double)(this.colorPos[1] - 32) / 128.0;
        if (xi >= 0.0 && xi <= 1.0 && yi >= 0.0 && yi <= 1.0) {
            Color c1 = NekoColors.getRGBColorBetween(xi, Color.WHITE, this.colorMapColor);
            if (this.activeSlot >= 0 && this.activeSlot < this.colors.length) {
                this.colors[this.activeSlot] = NekoColors.getRGBColorBetween(yi, c1, Color.BLACK);
            }
        }
    }

    private boolean isOnHuePicker(double x, double y) {
        double dx = x - (double)this.leftPos - 141.0;
        double dy = y - (double)this.topPos - 32.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 6.0 && dy <= 128.0;
    }

    private void getHue(double x, double y) {
        double yi = 1.0 - (y - (double)this.topPos - 32.0) / 128.0;
        this.colorMapColor = Color.getHSBColor((float)yi, 1.0f, 1.0f);
        this.updateColor();
        this.huePos = (int)y - this.topPos;
    }

    public boolean m_7043_() {
        return false;
    }
}

