/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering.entities;

import com.devbobcorn.nekoration.NekoConfig;
import com.devbobcorn.nekoration.client.rendering.PaintingRendererManager;
import com.devbobcorn.nekoration.client.rendering.entities.AbstractPaintingRenderer;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PaintingRenderer
extends EntityRenderer<PaintingEntity> {
    private static final Logger LOGGER = LogManager.getLogger((String)"Painting Renderer");
    private static Font font;

    public PaintingRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        font = ctx.m_174028_();
    }

    public void render(PaintingEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffers, int packedLight) {
        if (entity.data == null) {
            return;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotation));
        stack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        PaintingTextureManager paintingspriteuploader = Minecraft.m_91087_().m_91305_();
        this.renderPainting(stack, buffers, entity, entity.m_7076_(), entity.m_7068_(), paintingspriteuploader.m_118806_());
        stack.m_85849_();
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffers, packedLight);
    }

    public ResourceLocation getTextureLocation(PaintingEntity entity) {
        return Minecraft.m_91087_().m_91305_().m_118806_().m_247685_();
    }

    private void renderPainting(PoseStack stack, MultiBufferSource buffers, PaintingEntity entity, int width, int height, TextureAtlasSprite woodTex) {
        int entityLight;
        PoseStack.Pose PoseStack$entry = stack.m_85850_();
        Matrix4f pose = PoseStack$entry.m_252922_();
        Matrix3f normal = PoseStack$entry.m_252943_();
        float LEFT = (float)(-width) / 2.0f;
        float TOP = (float)(-height) / 2.0f;
        float woodU0 = woodTex.m_118409_();
        float woodU1 = woodTex.m_118410_();
        float woodV0 = woodTex.m_118411_();
        float woodV1 = woodTex.m_118412_();
        float woodV_ = woodTex.m_118393_(1.0);
        float woodU_ = woodTex.m_118367_(1.0);
        short blocHorCount = (short)(width / 16);
        short blocVerCount = (short)(height / 16);
        boolean fastRender = (Boolean)NekoConfig.CLIENT.simplifyRendering.get();
        boolean useImageRendering = (Boolean)NekoConfig.CLIENT.useImageRendering.get();
        boolean renderWithImage = entity.data.imageReady && useImageRendering;
        int light = entityLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)entity.m_31748_());
        for (short blocHor = 0; blocHor < blocHorCount; blocHor = (short)(blocHor + 1)) {
            for (short blocVer = 0; blocVer < blocVerCount; blocVer = (short)(blocVer + 1)) {
                float right = LEFT + (float)((blocHor + 1) * 16);
                float left = LEFT + (float)(blocHor * 16);
                float top = TOP + (float)((blocVer + 1) * 16);
                float bottom = TOP + (float)(blocVer * 16);
                if (!fastRender) {
                    int blocx = Mth.m_14107_((double)entity.m_20185_());
                    int blocy = Mth.m_14107_((double)(entity.m_20186_() + (double)((top + bottom) / 2.0f / 16.0f)));
                    int blocz = Mth.m_14107_((double)entity.m_20189_());
                    Direction direction = entity.m_6350_();
                    if (direction == Direction.NORTH) {
                        blocx = Mth.m_14107_((double)(entity.m_20185_() + (double)((right + left) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.WEST) {
                        blocz = Mth.m_14107_((double)(entity.m_20189_() - (double)((right + left) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.SOUTH) {
                        blocx = Mth.m_14107_((double)(entity.m_20185_() - (double)((right + left) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.EAST) {
                        blocz = Mth.m_14107_((double)(entity.m_20189_() + (double)((right + left) / 2.0f / 16.0f)));
                    }
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)new BlockPos(blocx, blocy, blocz));
                }
                VertexConsumer vb = buffers.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entity)));
                PaintingRenderer.vertexFrame(pose, normal, vb, right, top, woodU0, woodV0, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb, left, top, woodU1, woodV0, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb, left, bottom, woodU1, woodV1, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb, right, bottom, woodU0, woodV1, 0.5f, 0, 0, 1, light);
                if (blocVer == blocVerCount - 1) {
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, top, woodU0, woodV0, -0.5f, 0, 1, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, top, woodU1, woodV0, -0.5f, 0, 1, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, top, woodU1, woodV_, 0.5f, 0, 1, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, top, woodU0, woodV_, 0.5f, 0, 1, 0, light);
                }
                if (blocVer == 0) {
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, bottom, woodU0, woodV0, 0.5f, 0, -1, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, bottom, woodU1, woodV0, 0.5f, 0, -1, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, bottom, woodU1, woodV_, -0.5f, 0, -1, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, bottom, woodU0, woodV_, -0.5f, 0, -1, 0, light);
                }
                if (blocHor == blocHorCount - 1) {
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, top, woodU_, woodV0, 0.5f, -1, 0, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, bottom, woodU_, woodV1, 0.5f, -1, 0, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, bottom, woodU0, woodV1, -0.5f, -1, 0, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, right, top, woodU0, woodV0, -0.5f, -1, 0, 0, light);
                }
                if (blocHor == 0) {
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, top, woodU_, woodV0, -0.5f, 1, 0, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, bottom, woodU_, woodV1, -0.5f, 1, 0, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, bottom, woodU0, woodV1, 0.5f, 1, 0, 0, light);
                    PaintingRenderer.vertexFrame(pose, normal, vb, left, top, woodU0, woodV0, 0.5f, 1, 0, 0, light);
                }
                if (fastRender) continue;
                AbstractPaintingRenderer rd = null;
                if (renderWithImage) {
                    rd = PaintingRendererManager.get(entity.data.getPaintingHash());
                    if (rd == null) {
                        LOGGER.error("Image Renderer Not Ready!");
                        entity.data.imageReady = false;
                        rd = PaintingRendererManager.PixelsRenderer();
                    }
                } else {
                    rd = PaintingRendererManager.PixelsRenderer();
                }
                ((AbstractPaintingRenderer)rd).render(stack, pose, normal, buffers, entity.data, blocHor, blocVer, left, bottom, light);
            }
        }
        if (fastRender) {
            AbstractPaintingRenderer rd = null;
            if (renderWithImage) {
                rd = PaintingRendererManager.get(entity.data.getPaintingHash());
                if (rd == null) {
                    LOGGER.error("Image Renderer Not Ready!");
                    entity.data.imageReady = false;
                    rd = PaintingRendererManager.PixelsRenderer();
                }
            } else {
                rd = PaintingRendererManager.PixelsRenderer();
            }
            ((AbstractPaintingRenderer)rd).renderFull(stack, pose, normal, buffers, entity.data, LEFT, TOP, light);
        }
        if (((Boolean)NekoConfig.CLIENT.debugMode.get()).booleanValue()) {
            stack.m_85836_();
            stack.m_85837_((double)(-LEFT) - 1.0, (double)TOP + 3.0, -0.6);
            stack.m_85841_(-0.2f, -0.2f, 0.2f);
            font.m_92883_(stack, (renderWithImage ? "Rendered with Image" : "Rendered Pixel-by-Pixel") + (fastRender ? " (Fast Mode)" : " (Fancy Mode)"), 1.0f, 1.0f, 0xFFFFFF);
            stack.m_85837_(0.0, -10.0, 0.0);
            font.m_92883_(stack, "#" + String.valueOf(entity.data.getPaintingHash()) + String.format(" L: %x", entityLight), 1.0f, 1.0f, 0xFFFFFF);
            stack.m_85837_(0.0, 30.0, 0.0);
            font.m_92883_(stack, String.valueOf(entity.data.getUUID()), 1.0f, 1.0f, 0xFFFFFF);
            stack.m_85837_(0.0, 10.0, 0.0);
            font.m_92883_(stack, String.valueOf(entity.m_20148_()), 1.0f, 1.0f, 0xFFFFFF);
            stack.m_85849_();
        }
    }

    private static void vertexFrame(Matrix4f pose, Matrix3f normal, VertexConsumer vertexBuilder, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        vertexBuilder.m_252986_(pose, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, (float)nx, (float)ny, (float)nz).m_5752_();
    }
}

