/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.entities;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.NekoConfig;
import com.devbobcorn.nekoration.utils.PixelPos;
import com.devbobcorn.nekoration.utils.TagTypes;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaintingData {
    public static final Logger LOGGER = LogManager.getLogger((String)"Painting Data");
    private short width;
    private short height;
    private final UUID uuid;
    public final boolean isClient;
    private int[] canvas;
    private int[] pixels;
    private int[] composite;
    private int paintingHash;
    public boolean imageReady = false;
    private static final String CACHE_PATH = "nekocache";
    private static final int canvasize = 128;
    boolean[][] visited = new boolean[128][128];
    private static final int[] offsetX = new int[]{1, -1, 0, 0, 1, -1, 1, -1};
    private static final int[] offsetY = new int[]{0, 0, 1, -1, 1, 1, -1, -1};
    private boolean connectDiagonal = false;

    public PaintingData(short w, short h, boolean client, UUID seed) {
        this.width = w;
        this.height = h;
        this.pixels = new int[w * h];
        this.uuid = seed;
        this.isClient = client;
        if (this.isClient) {
            Random random = new Random(seed.hashCode());
            this.canvas = new int[w * h];
            this.composite = new int[w * h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int n = i % 16 == 0 || j % 16 == 0 ? 12230784 : 15390384;
                    this.canvas[i + j * w] = n;
                    this.composite[i + j * w] = n;
                }
            }
            int bottom = (h - 1) * w;
            int right = w - 1;
            for (int i = 0; i < w; ++i) {
                this.composite[i] = this.canvas[i] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                int n = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[i + bottom] = n;
                this.composite[i + bottom] = n;
            }
            for (int j = 1; j < h - 1; ++j) {
                int n = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[j * w] = n;
                this.composite[j * w] = n;
                int n2 = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[right + j * w] = n2;
                this.composite[right + j * w] = n2;
            }
            this.updatePaintingHash();
            if (((Boolean)NekoConfig.CLIENT.useImageRendering.get()).booleanValue()) {
                this.cache();
            }
        }
    }

    public PaintingData(short w, short h, int[] pix, boolean client, UUID seed) {
        this.width = w;
        this.height = h;
        this.pixels = pix;
        this.uuid = seed;
        this.isClient = client;
        if (this.isClient) {
            Random random = new Random(seed.hashCode());
            this.canvas = new int[w * h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    this.canvas[i + j * w] = i % 16 == 0 || j % 16 == 0 ? 12230784 : 15390384;
                }
            }
            int bottom = (h - 1) * w;
            int right = w - 1;
            for (int i = 0; i < w; ++i) {
                this.canvas[i] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[i + bottom] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
            }
            for (int j = 1; j < h - 1; ++j) {
                this.canvas[j * w] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[right + j * w] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
            }
            this.composite = new int[w * h];
            this.recalculateComposite();
            this.updatePaintingHash();
            if (((Boolean)NekoConfig.CLIENT.useImageRendering.get()).booleanValue()) {
                this.imageReady = this.cache();
            }
        }
    }

    public boolean cache() {
        File fileCheck;
        Minecraft minecraft = Minecraft.m_91087_();
        File pathCheck = new File(minecraft.f_91069_, CACHE_PATH);
        if (pathCheck.isDirectory() && (fileCheck = new File(pathCheck, this.getPaintingHash() + ".png")).exists()) {
            LOGGER.info("Painting #" + this.getPaintingHash() + " already cached.");
            return true;
        }
        this.imageReady = this.save(CACHE_PATH, String.valueOf(this.getPaintingHash()), true, false);
        return this.imageReady;
    }

    public boolean save(String path, String name, boolean composite, boolean showMessage) {
        try {
            String ext;
            Minecraft minecraft = Minecraft.m_91087_();
            BufferedImage image = new BufferedImage(this.width, this.height, 2);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    image.setRGB(i, j, composite ? -16777216 + this.getCompositeAt(i, j) : this.getPixelAt(i, j));
                }
            }
            File folder = new File(minecraft.f_91069_, path);
            if (!folder.exists() && !folder.mkdir()) {
                throw new IOException("Could not create folder");
            }
            List<String> suf = Arrays.asList("png", "jpeg", "jpg");
            boolean hasExt = suf.contains(ext = name.toLowerCase().substring(name.lastIndexOf(".") + 1));
            File file = new File(folder, (String)(hasExt ? name : name + ".png"));
            if (!hasExt) {
                ext = "png";
            }
            LOGGER.info("Painting saved to " + file.getAbsolutePath() + " in " + ext + " format.");
            if (!ImageIO.write((RenderedImage)image, ext, file)) {
                throw new IOException("Could not encode image as specified(" + ext + ")!");
            }
            if (showMessage) {
                MutableComponent component = Component.m_237113_((String)file.getName());
                component = component.m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
                minecraft.f_91074_.m_5661_((Component)Component.m_237110_((String)("gui.nekoration.message." + (composite ? "painting_saved" : "painting_content_saved")), (Object[])new Object[]{component}), false);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            this.imageReady = false;
            return false;
        }
    }

    public boolean load(String path, String name) {
        Minecraft minecraft = Minecraft.m_91087_();
        String[] params = name.split(">");
        int[] offsetl = new int[]{0, 0, 0, 0};
        double scalel = 1.0;
        int[] sizel = new int[]{99999, 99999};
        try {
            BufferedImage image;
            block9: for (int p = 0; p < params.length; ++p) {
                params[p] = params[p].trim();
                switch (p) {
                    case 0: {
                        name = params[p];
                        continue block9;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        offsetl[p - 1] = Integer.parseInt(params[p]);
                        continue block9;
                    }
                    case 5: {
                        scalel = Mth.m_14008_((double)Double.parseDouble(params[p]), (double)0.01, (double)100.0);
                        continue block9;
                    }
                    case 6: 
                    case 7: {
                        sizel[p - 6] = Integer.parseInt(params[p]);
                    }
                }
            }
            if (path.equals("<url>")) {
                image = ImageIO.read(new URL(name));
            } else {
                String ext;
                File folder = new File(minecraft.f_91069_, path);
                if (!folder.exists()) {
                    throw new IOException("Could not find folder");
                }
                List<String> suf = Arrays.asList("png", "jpeg", "jpg");
                boolean hasExt = suf.contains(ext = name.toLowerCase().substring(name.lastIndexOf(".") + 1));
                File file = new File(folder, (String)(hasExt ? name : name + ".png"));
                if (!file.exists()) {
                    throw new IOException("Could not find file");
                }
                image = ImageIO.read(file);
            }
            if (image == null) {
                LOGGER.error("Image is not available!");
                return false;
            }
            if ((offsetl[2] > 0 || offsetl[3] > 0 || sizel[0] != 99999 || sizel[1] != 99999) && image.getWidth() > offsetl[2] && image.getHeight() > offsetl[3]) {
                int cropW = Math.min(image.getWidth() - offsetl[2], sizel[0]);
                int cropH = Math.min(image.getHeight() - offsetl[3], sizel[1]);
                image = image.getSubimage(offsetl[2], offsetl[3], cropW, cropH);
            }
            if (scalel != 1.0) {
                short newW = (short)Math.ceil((double)image.getWidth() * scalel);
                short newH = (short)Math.ceil((double)image.getHeight() * scalel);
                Image scaled = image.getScaledInstance(newW, newH, 1);
                BufferedImage scaledImage = new BufferedImage(newW, newH, 2);
                Graphics2D g2d = scaledImage.createGraphics();
                g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                g2d.drawImage(scaled, 0, 0, newW, newH, null);
                for (int i = offsetl[0]; i < Math.min(offsetl[0] + scaledImage.getWidth(), this.width); ++i) {
                    for (int j = offsetl[1]; j < Math.min(offsetl[1] + scaledImage.getHeight(), this.height); ++j) {
                        this.pixels[j * this.width + i] = scaledImage.getRGB(i - offsetl[0], j - offsetl[1]);
                    }
                }
            } else {
                for (int i = offsetl[0]; i < Math.min(offsetl[0] + image.getWidth(), this.width); ++i) {
                    for (int j = offsetl[1]; j < Math.min(offsetl[1] + image.getHeight(), this.height); ++j) {
                        this.pixels[j * this.width + i] = image.getRGB(i - offsetl[0], j - offsetl[1]);
                    }
                }
            }
            this.recalculateComposite();
            LOGGER.info(String.format("Painting '%s' Loaded: %s x %s", name, image.getWidth(), image.getHeight()));
            return true;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            MutableComponent component = Component.m_237113_((String)name);
            minecraft.f_91074_.m_5661_((Component)Component.m_237110_((String)"gui.nekoration.message.painting_load_failed", (Object[])new Object[]{component}), false);
            return false;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    public boolean clearCache(int target) {
        File file;
        Minecraft minecraft = Minecraft.m_91087_();
        File path = new File(minecraft.f_91069_, CACHE_PATH);
        if (path.isDirectory() && (file = new File(path, target + ".png")).delete()) {
            LOGGER.info("Painting #" + target + " cache cleared.");
            return true;
        }
        return false;
    }

    private void updatePaintingHash() {
        this.paintingHash = Arrays.hashCode(this.composite);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getPaintingHash() {
        return this.paintingHash;
    }

    public static void writeTo(PaintingData data, CompoundTag tag) {
        tag.m_128376_("Width", data.width);
        tag.m_128376_("Height", data.height);
        tag.m_128385_("Pixels", data.pixels);
        tag.m_128362_("DataID", data.uuid);
    }

    public static PaintingData readFrom(CompoundTag tag, UUID defaultId) {
        UUID dataid = tag.m_128425_("DataID", (int)TagTypes.INT_ARRAY_NBT_ID) ? tag.m_128342_("DataID") : defaultId;
        return new PaintingData(tag.m_128448_("Width"), tag.m_128448_("Height"), tag.m_128465_("Pixels"), false, dataid);
    }

    private boolean isLegal(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int[] getComposite() {
        return this.composite;
    }

    public void setPixels(int[] pixels) {
        if (pixels.length == this.pixels.length) {
            this.pixels = Arrays.copyOf(pixels, pixels.length);
        }
        if (this.isClient) {
            this.recalculateComposite();
        }
    }

    public void setAreaPixels(byte partX, byte partY, byte partW, byte partH, int[] pixels) {
        for (int i = 0; i < partW * 16; ++i) {
            for (int j = 0; j < partH * 16; ++j) {
                int x = partX * 3 * 16 + i;
                int y = partY * 3 * 16 + j;
                if (!this.isLegal(x, y)) {
                    LOGGER.error("Illegal Coordinate: " + x + ", " + y);
                }
                this.pixels[y * this.width + x] = pixels[j * partW * 16 + i];
            }
        }
        if (this.isClient) {
            this.recalculateComposite();
        }
    }

    public void setPixel(int x, int y, int color, boolean blend) {
        if (this.isLegal(x, y)) {
            int n = this.pixels[y * this.width + x] = blend ? PaintingData.blendColor(this.pixels[y * this.width + x], color) : color;
            if (this.isClient) {
                this.recalculateCompositeAt(x, y);
            }
        }
    }

    public void clearPixel(int x, int y) {
        if (this.isLegal(x, y)) {
            this.pixels[y * this.width + x] = 0;
            if (this.isClient) {
                this.recalculateCompositeAt(x, y);
            }
        }
    }

    public int fill(int x, int y, int color, int opacity, int thresold, boolean blend) {
        if (!this.isLegal(x, y)) {
            return 0;
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                this.visited[i][j] = false;
            }
        }
        this.pixSearch(x, y, thresold);
        int cnt = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (!this.visited[i][j]) continue;
                ++cnt;
                this.pixels[i + j * this.width] = blend ? PaintingData.blendColor(this.pixels[i + j * this.width], (opacity << 24) + color) : (opacity << 24) + color;
            }
        }
        this.recalculateComposite();
        return cnt;
    }

    private boolean checkAvailable(PixelPos pix) {
        if (!this.isLegal(pix.x, pix.y)) {
            return false;
        }
        return !this.visited[pix.x][pix.y];
    }

    private void setVisited(PixelPos pix) {
        this.visited[pix.x][pix.y] = true;
    }

    private boolean checkColor(int origin, PixelPos pix, int threshold) {
        float bo;
        float go;
        int target = this.getCompositeAt(pix.x, pix.y);
        float ro = (origin & 0xFF0000) - (target & 0xFF0000);
        return Mth.m_14116_((float)(ro * ro + (go = (float)((origin & 0xFF00) - (target & 0xFF00))) * go + (bo = (float)((origin & 0xFF) - (target & 0xFF))) * bo)) < (float)(threshold * threshold);
    }

    private void pixSearch(int x, int y, int threshold) {
        int originColor = this.getCompositeAt(x, y);
        LinkedList<PixelPos> queue = new LinkedList<PixelPos>();
        queue.add(new PixelPos(x, y));
        this.visited[x][y] = true;
        while (!queue.isEmpty()) {
            PixelPos pix = (PixelPos)queue.poll();
            for (int i = 0; i < (this.connectDiagonal ? 8 : 4); ++i) {
                PixelPos tar = pix.offset(offsetX[i], offsetY[i]);
                if (!this.checkAvailable(tar) || !this.checkColor(originColor, tar, threshold)) continue;
                queue.add(tar);
                this.setVisited(tar);
            }
        }
    }

    private void recalculateComposite() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.composite[y * this.width + x] = NekoColors.getRGBColorBetween((double)(this.pixels[y * this.width + x] >> 24 & 0xFF) / 255.0, this.canvas[y * this.width + x], this.pixels[y * this.width + x]);
            }
        }
        this.updatePaintingHash();
    }

    private void recalculateCompositeAt(int x, int y) {
        this.composite[y * this.width + x] = NekoColors.getRGBColorBetween((double)(this.pixels[y * this.width + x] >> 24 & 0xFF) / 255.0, this.canvas[y * this.width + x], this.pixels[y * this.width + x]);
        this.updatePaintingHash();
    }

    public int getCompositeAt(int x, int y) {
        return this.composite[x + y * this.width];
    }

    public int getPixelAt(int x, int y) {
        return this.pixels[x + y * this.width];
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    private static int blendColor(int desc, int tarc) {
        int tara = (tarc & 0xFF000000) >>> 24;
        int desa = (desc & 0xFF000000) >>> 24;
        double blendfrac = Mth.m_14008_((double)((double)tara / (double)(tara + desa)), (double)0.0, (double)1.0);
        int blenda = Mth.m_14045_((int)(tara + desa), (int)0, (int)255);
        return NekoColors.getRGBColorBetween(blendfrac, desc, tarc) + (blenda << 24);
    }
}

