/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.items;

import com.devbobcorn.nekoration.client.ClientHelper;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.devbobcorn.nekoration.utils.TagTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class PaintingItem
extends Item {
    public static final String TYPE = "type";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DATAID = "dataid";
    public static final String PIXELS = "pixels";
    public static final String ENTITYID = "entityid";

    public PaintingItem(Item.Properties settings) {
        super(settings);
    }

    public static float getTypePropertyOverride(ItemStack itemStack, @Nullable Level world, @Nullable LivingEntity livingEntity, int what) {
        return PaintingItem.getType(itemStack);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult m_6225_(UseOnContext ctx) {
        PaintingEntity painting;
        Level world;
        ItemStack stack;
        BlockPos blockpos1;
        block10: {
            Direction direction;
            block11: {
                BlockPos blockpos = ctx.m_8083_();
                direction = ctx.m_43719_();
                blockpos1 = blockpos.m_121945_(direction);
                Player player = ctx.m_43723_();
                stack = ctx.m_43722_();
                if (player != null && !this.mayPlace(player, direction, stack, blockpos1)) {
                    return InteractionResult.FAIL;
                }
                world = ctx.m_43725_();
                CompoundTag tag = stack.m_41784_();
                if (!tag.m_128425_(TYPE, (int)TagTypes.BYTE_NBT_ID)) break block11;
                if (tag.m_128445_(TYPE) == Type.PAINTED.id) {
                    painting = new PaintingEntity(world, blockpos1, direction, (short)(PaintingItem.getWidth(stack) * 16), (short)(PaintingItem.getHeight(stack) * 16), tag.m_128342_(DATAID));
                    if (!world.f_46443_) {
                        painting.data.setPixels(tag.m_128465_(PIXELS));
                    }
                    break block10;
                } else {
                    if (tag.m_128445_(TYPE) == Type.MAGIC.id) {
                        painting = new PaintingEntity(world, blockpos1, direction, (short)(PaintingItem.getWidth(stack) * 16), (short)(PaintingItem.getHeight(stack) * 16), tag.m_128342_(DATAID));
                        Entity entity = world.m_6815_(tag.m_128451_(ENTITYID));
                        if (entity instanceof PaintingEntity) {
                            painting.data.setPixels((int[])((PaintingEntity)entity).data.getPixels().clone());
                            break block10;
                        } else {
                            if (world.f_46443_) {
                                player.m_5661_((Component)Component.m_237115_((String)"gui.nekoration.message.link_expired"), true);
                            }
                            return InteractionResult.FAIL;
                        }
                    }
                    painting = new PaintingEntity(world, blockpos1, direction, (short)(PaintingItem.getWidth(stack) * 16), (short)(PaintingItem.getHeight(stack) * 16));
                }
                break block10;
            }
            painting = new PaintingEntity(world, blockpos1, direction, (short)(PaintingItem.getWidth(stack) * 16), (short)(PaintingItem.getHeight(stack) * 16));
        }
        painting.m_6034_(blockpos1.m_123341_(), blockpos1.m_123342_(), blockpos1.m_123343_());
        if (!painting.m_7088_()) {
            return InteractionResult.CONSUME;
        }
        if (!world.f_46443_) {
            painting.m_7084_();
            world.m_7967_((Entity)painting);
        }
        stack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        boolean hasType = tag.m_128425_(TYPE, (int)TagTypes.BYTE_NBT_ID);
        if (!hasType || hasType && tag.m_128445_(TYPE) == Type.BLANK.id) {
            if (world.f_46443_) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.showPaintingSizeScreen(hand, stack.m_41613_()));
            }
        } else if (hasType && tag.m_128445_(TYPE) == Type.MAGIC.id && !world.f_46443_) {
            tag.m_128473_("DataId");
            tag.m_128473_("EntityId");
            tag.m_128344_(TYPE, Type.BLANK.id);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    protected boolean mayPlace(Player player, Direction dir, ItemStack stack, BlockPos pos) {
        return !dir.m_122434_().m_122478_() && player.m_36204_(pos, dir, stack);
    }

    public static int getWidth(ItemStack stack) {
        short w = stack.m_41784_().m_128448_(WIDTH);
        return w <= 0 ? (short)1 : w;
    }

    public static void setWidth(ItemStack stack, short w) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128376_(WIDTH, w);
    }

    public static int getHeight(ItemStack stack) {
        short h = stack.m_41784_().m_128448_(HEIGHT);
        return h <= 0 ? (short)1 : h;
    }

    public static void setHeight(ItemStack stack, short h) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128376_(HEIGHT, h);
    }

    public static byte getType(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(TYPE, (int)TagTypes.BYTE_NBT_ID)) {
            return tag.m_128445_(TYPE);
        }
        return Type.BLANK.id;
    }

    public static void setContent(ItemStack stack, short w, short h, UUID seed, int[] pixels) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_(TYPE, Type.PAINTED.id);
        tag.m_128376_(WIDTH, w);
        tag.m_128376_(HEIGHT, h);
        tag.m_128362_(DATAID, seed);
        tag.m_128385_(PIXELS, pixels);
    }

    public static void setSize(ItemStack stack, short w, short h) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_(TYPE, Type.BLANK.id);
        tag.m_128376_(WIDTH, w);
        tag.m_128376_(HEIGHT, h);
    }

    public static void setLink(ItemStack stack, short w, short h, UUID DataId, int EntityId) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_(TYPE, Type.MAGIC.id);
        tag.m_128376_(WIDTH, w);
        tag.m_128376_(HEIGHT, h);
        tag.m_128362_(DATAID, DataId);
        tag.m_128405_(ENTITYID, EntityId);
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)(this.m_5671_(stack) + "." + Type.fromId((byte)PaintingItem.getType((ItemStack)stack)).name), (Object[])new Object[]{PaintingItem.getWidth(stack), PaintingItem.getHeight(stack)});
    }

    public static enum Type {
        BLANK(0, "blank"),
        PAINTED(1, "painted"),
        MAGIC(2, "magic");

        public final byte id;
        public final String name;

        private Type(byte id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Type fromId(byte id) {
            for (Type p : Type.values()) {
                if (p.id != id) continue;
                return p;
            }
            return BLANK;
        }
    }
}

