/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.blocks.entities.EaselMenuBlockEntity;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.network.S2CUpdateEaselMenuData;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class C2SUpdateEaselMenuData {
    public Component[] texts = new Component[8];
    public DyeColor[] colors = new DyeColor[8];
    public BlockPos pos = BlockPos.f_121853_;
    public boolean glow = false;

    public C2SUpdateEaselMenuData(BlockPos pos, Component[] texts, DyeColor[] colors, boolean glowing) {
        this.pos = pos;
        this.texts = texts;
        this.colors = colors;
        this.glow = glowing;
    }

    public static void encode(C2SUpdateEaselMenuData msg, FriendlyByteBuf packetBuffer) {
        int i;
        packetBuffer.m_130064_(msg.pos);
        for (i = 0; i < 8; ++i) {
            packetBuffer.m_130083_(msg.texts[i]);
        }
        for (i = 0; i < 8; ++i) {
            packetBuffer.m_130068_((Enum)msg.colors[i]);
        }
        packetBuffer.writeBoolean(msg.glow);
    }

    public static C2SUpdateEaselMenuData decode(FriendlyByteBuf packetBuffer) {
        int i;
        BlockPos pos = packetBuffer.m_130135_();
        Component[] t = new Component[8];
        DyeColor[] c = new DyeColor[8];
        for (i = 0; i < 8; ++i) {
            t[i] = packetBuffer.m_130238_();
        }
        for (i = 0; i < 8; ++i) {
            c[i] = (DyeColor)packetBuffer.m_130066_(DyeColor.class);
        }
        boolean g = packetBuffer.readBoolean();
        return new C2SUpdateEaselMenuData(pos, t, c, g);
    }

    public static void handle(C2SUpdateEaselMenuData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockEntity tileEntity;
            ServerLevel world;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null && (world = player.m_9236_()).m_46749_(msg.pos) && (tileEntity = world.m_7702_(msg.pos)) instanceof EaselMenuBlockEntity) {
                EaselMenuBlockEntity te = (EaselMenuBlockEntity)tileEntity;
                for (int i = 0; i < 8; ++i) {
                    te.setMessage(i, msg.texts[i]);
                }
                te.setColors(msg.colors);
                te.setGlowing(msg.glow);
                world.m_7726_().m_8450_(msg.pos);
                tileEntity.m_6596_();
                ItemStack[] its = new ItemStack[8];
                for (int i = 0; i < 8; ++i) {
                    its[i] = te.m_8020_(i);
                }
                S2CUpdateEaselMenuData packet = new S2CUpdateEaselMenuData(msg.pos, its, msg.texts, msg.colors, msg.glow);
                ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

