/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.network.S2CUpdatePaintingData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class C2SUpdatePaintingData {
    public int paintingId;
    public byte partX;
    public byte partY;
    public byte partW;
    public byte partH;
    public int[] pixels;
    public int compositeHash;

    public C2SUpdatePaintingData(int id, byte x, byte y, byte w, byte h, int[] pixels, int hash) {
        this.paintingId = id;
        this.partX = x;
        this.partY = y;
        this.partW = w;
        this.partH = h;
        this.pixels = pixels;
        this.compositeHash = hash;
    }

    public static void encode(C2SUpdatePaintingData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.paintingId);
        packetBuffer.writeByte((int)msg.partX);
        packetBuffer.writeByte((int)msg.partY);
        packetBuffer.writeByte((int)msg.partW);
        packetBuffer.writeByte((int)msg.partH);
        packetBuffer.m_130089_(msg.pixels);
        packetBuffer.writeInt(msg.compositeHash);
    }

    public static C2SUpdatePaintingData decode(FriendlyByteBuf packetBuffer) {
        int i = packetBuffer.readInt();
        byte x = packetBuffer.readByte();
        byte y = packetBuffer.readByte();
        byte w = packetBuffer.readByte();
        byte h = packetBuffer.readByte();
        int[] p = packetBuffer.m_130100_();
        int hash = packetBuffer.readInt();
        return new C2SUpdatePaintingData(i, x, y, w, h, p, hash);
    }

    public static void handle(C2SUpdatePaintingData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(msg.paintingId)) instanceof PaintingEntity) {
                ((PaintingEntity)entity).data.setAreaPixels(msg.partX, msg.partY, msg.partW, msg.partH, msg.pixels);
                S2CUpdatePaintingData packet = new S2CUpdatePaintingData(msg.paintingId, msg.partX, msg.partY, msg.partW, msg.partH, msg.pixels, msg.compositeHash);
                ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

