/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.items.ModItems;
import com.devbobcorn.nekoration.items.PaintingItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class C2SUpdatePaintingSize {
    public InteractionHand hand;
    public short width;
    public short height;
    public int count;

    public C2SUpdatePaintingSize(InteractionHand hand, short w, short h, int c) {
        this.hand = hand;
        this.width = w;
        this.height = h;
        this.count = c;
    }

    public static void encode(C2SUpdatePaintingSize msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)msg.hand);
        packetBuffer.writeShort((int)msg.width);
        packetBuffer.writeShort((int)msg.height);
        packetBuffer.writeInt(msg.count);
    }

    public static C2SUpdatePaintingSize decode(FriendlyByteBuf packetBuffer) {
        InteractionHand hand = (InteractionHand)packetBuffer.m_130066_(InteractionHand.class);
        short w = packetBuffer.readShort();
        short h = packetBuffer.readShort();
        int c = packetBuffer.readInt();
        return new C2SUpdatePaintingSize(hand, w, h, c);
    }

    public static void handle(C2SUpdatePaintingSize msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null) {
                ItemStack updated = new ItemStack((ItemLike)ModItems.PAINTING.get(), msg.count);
                PaintingItem.setWidth(updated, msg.width);
                PaintingItem.setHeight(updated, msg.height);
                player.m_21008_(msg.hand, updated);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

