/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.blocks.entities.ItemDisplayBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class S2CUpdateCupboardData {
    public ItemStack[] items = new ItemStack[4];
    public BlockPos pos = BlockPos.f_121853_;

    public S2CUpdateCupboardData(BlockPos pos, ItemStack[] items) {
        this.pos = pos;
        this.items = items;
    }

    public static void encode(S2CUpdateCupboardData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(msg.pos);
        for (int i = 0; i < 4; ++i) {
            packetBuffer.writeItemStack(msg.items[i], false);
        }
    }

    public static S2CUpdateCupboardData decode(FriendlyByteBuf packetBuffer) {
        BlockPos pos = packetBuffer.m_130135_();
        ItemStack[] t = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            t[i] = packetBuffer.m_130267_();
        }
        return new S2CUpdateCupboardData(pos, t);
    }

    public static void handle(S2CUpdateCupboardData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockEntity tileEntity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world.m_46749_(msg.pos) && (tileEntity = world.m_7702_(msg.pos)) instanceof ItemDisplayBlockEntity) {
                ItemDisplayBlockEntity te = (ItemDisplayBlockEntity)tileEntity;
                for (int i = 0; i < 4; ++i) {
                    te.renderItems[i] = msg.items[i];
                }
                tileEntity.m_6596_();
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

