/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.utils;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.items.ModItems;
import com.devbobcorn.nekoration.items.PaletteItem;
import com.devbobcorn.nekoration.utils.TagTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.lang.reflect.Field;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class VoxelShapeHighlighter {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Field worldField;
    private static boolean loggedReflectionError;
    private static boolean HoldingPalette;
    public static Color PaletteColor;
    private static int lastHolding;

    @SubscribeEvent
    public static void onDrawBlockHighlightEvent(RenderHighlightEvent.Block event) {
        Level world;
        BlockHitResult rayTraceResult = event.getTarget();
        Minecraft mc = Minecraft.m_91087_();
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        try {
            world = VoxelShapeHighlighter.getPrivateWorldFromWorldRenderer(event.getLevelRenderer());
        }
        catch (IllegalAccessException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            if (!loggedReflectionError) {
                LOGGER.error("Could not find WorldRenderer.world");
            }
            loggedReflectionError = true;
            return;
        }
        BlockPos blockpos = rayTraceResult.m_82425_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60795_() || !world.m_6857_().m_61937_(blockpos)) {
            return;
        }
        ItemStack itemStack = mc.f_91074_.m_21205_();
        if (itemStack.m_41720_() == ModItems.PALETTE.get()) {
            int holding = mc.f_91074_.m_150109_().f_35977_;
            if (!HoldingPalette || lastHolding != holding) {
                CompoundTag nbt = itemStack.m_41784_();
                if (nbt.m_128425_("active", (int)TagTypes.BYTE_NBT_ID)) {
                    byte a = nbt.m_128445_("active");
                    int[] c = nbt.m_128465_("colors");
                    PaletteColor = NekoColors.getRGBColor(c[a]);
                } else {
                    PaletteColor = PaletteItem.DEFAULT_COLOR_SET[0];
                }
                lastHolding = holding;
                HoldingPalette = true;
            }
            Camera ari = event.getCamera();
            VoxelShape shape = blockstate.m_60651_((BlockGetter)world, blockpos, CollisionContext.m_82750_((Entity)ari.m_90592_()));
            VoxelShapeHighlighter.drawSelectionBox(event.getLevelRenderer(), event.getMultiBufferSource(), event.getPoseStack(), blockpos, ari, shape, PaletteColor);
            event.setCanceled(true);
        } else if (HoldingPalette) {
            HoldingPalette = false;
        }
    }

    private static void drawSelectionBox(LevelRenderer worldRenderer, MultiBufferSource renderTypeBuffers, PoseStack matrixStack, BlockPos blockPos, Camera activeRenderInfo, VoxelShape shape, Color color) {
        RenderType renderType = RenderType.m_110504_();
        VertexConsumer vertexBuilder = renderTypeBuffers.m_6299_(renderType);
        double eyeX = activeRenderInfo.m_90583_().m_7096_();
        double eyeY = activeRenderInfo.m_90583_().m_7098_();
        double eyeZ = activeRenderInfo.m_90583_().m_7094_();
        float ALPHA = 0.5f;
        VoxelShapeHighlighter.drawShapeOutline(matrixStack, vertexBuilder, shape, (double)blockPos.m_123341_() - eyeX, (double)blockPos.m_123342_() - eyeY, (double)blockPos.m_123343_() - eyeZ, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
    }

    private static void drawShapeOutline(PoseStack matrixStack, VertexConsumer vertexBuilder, VoxelShape voxelShape, double originX, double originY, double originZ, float red, float green, float blue, float alpha) {
        PoseStack.Pose matrix4f = matrixStack.m_85850_();
        voxelShape.m_83224_((x0, y0, z0, x1, y1, z1) -> {
            float f = (float)(x1 - x0);
            float f1 = (float)(y1 - y0);
            float f2 = (float)(z1 - z0);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            vertexBuilder.m_252986_(matrix4f.m_252922_(), (float)(x0 + originX), (float)(y0 + originY), (float)(z0 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(matrix4f.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            vertexBuilder.m_252986_(matrix4f.m_252922_(), (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(matrix4f.m_252943_(), f, f1, f2).m_5752_();
        });
    }

    private static Level getPrivateWorldFromWorldRenderer(LevelRenderer worldRenderer) throws IllegalAccessException, ObfuscationReflectionHelper.UnableToFindFieldException {
        if (worldField == null) {
            worldField = ObfuscationReflectionHelper.findField(LevelRenderer.class, (String)"f_109465_");
        }
        return (Level)worldField.get(worldRenderer);
    }

    static {
        loggedReflectionError = false;
        HoldingPalette = false;
        PaletteColor = Color.RED;
        lastHolding = 1202;
    }
}

