/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.config;

import io.github.orlouge.structurepalettes.config.Condition;
import io.github.orlouge.structurepalettes.config.PaletteEntry;
import io.github.orlouge.structurepalettes.config.TargetEntry;
import io.github.orlouge.structurepalettes.config.TransformEntry;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.Tuple;

public class Config {
    private final Collection<TransformEntry> transformations;
    private final Collection<PaletteEntry> palettes;

    public Config(Collection<TransformEntry> transformations, Collection<PaletteEntry> palettes) {
        this.transformations = transformations;
        this.palettes = palettes;
    }

    public static Config load(Path folder) throws IOException, ConfigParseException {
        Parser parser = new Parser();
        if (Files.exists(folder, new LinkOption[0])) {
            Iterator iter = Files.walk(folder, FileVisitOption.FOLLOW_LINKS).iterator();
            while (iter.hasNext()) {
                Path path = (Path)iter.next();
                if (!path.toString().toLowerCase().endsWith(".txt")) continue;
                parser.parse(Files.readAllLines(path));
            }
        } else {
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        return parser.getConfig();
    }

    public Collection<TransformEntry> getTransformations() {
        return this.transformations;
    }

    public Collection<PaletteEntry> getPalettes() {
        return this.palettes;
    }

    private static class Parser {
        private final LinkedList<TransformEntry> transformations = new LinkedList();
        private final LinkedList<PaletteEntry> palettes = new LinkedList();
        private List<Tuple<Double, String>> currentPaletteGroups = null;
        private List<PaletteEntry.Mapping> currentPaletteMappings = new LinkedList<PaletteEntry.Mapping>();
        private static final String paletteDefinitionGroup = "(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*)";
        private static final String paletteDefinitionHead = "(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*)(\\s*,\\s*(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*))*\\s*:";
        private static final String condition = "(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?";
        private static final String conditions = "(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?(\\s*,\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?)*\\s*";
        private static final String sourceBlock = "(?<sourceblock>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*)";
        private static final String targetBlock = "(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?)";
        private static final String targetBlocks = "(?<targetblocks>(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?)(\\s*,\\s*(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?))*)\\s*";
        private static final String paletteDefinitionBody = "(?<sourceblock>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*)\\s*(?<mappingconditions>\\(\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?(\\s*,\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?)*\\s*\\s*\\))?\\s*\\s*->\\s*(?<targetblocks>(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?)(\\s*,\\s*(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?))*)\\s*";
        private static final String targetStructure = "((?<structure>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+)|\\*)";
        private static final String targetBiome = "(?<biome>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+|\\*)(\\s*(?<biomeadd>\\+))?";
        private static final String paletteGroupUsage = "(?<palettegroup>[A-z_][A-z_0-9]*)";
        private static final String structureTransformation = "((?<chance>[0-9.]+)%\\s)?\\s*((?<transformgroup>[A-z_][A-z_0-9]*)?:(?<order>[0-9]+)?\\s)?\\s*(?<palettegroup>[A-z_][A-z_0-9]*)\\s*=>\\s*((?<structure>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+)|\\*)\\s*(\\(\\s*(?<biome>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+|\\*)(\\s*(?<biomeadd>\\+))?\\s*\\))?";
        private static final String root = "\\s*(?<palettehead>(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*)(\\s*,\\s*(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*))*\\s*:\\s*(//.*)?)|(?<palettebody>(?<sourceblock>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*)\\s*(?<mappingconditions>\\(\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?(\\s*,\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?)*\\s*\\s*\\))?\\s*\\s*->\\s*(?<targetblocks>(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?)(\\s*,\\s*(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?))*)\\s*\\s*(//.*)?)|(?<transformation>((?<chance>[0-9.]+)%\\s)?\\s*((?<transformgroup>[A-z_][A-z_0-9]*)?:(?<order>[0-9]+)?\\s)?\\s*(?<palettegroup>[A-z_][A-z_0-9]*)\\s*=>\\s*((?<structure>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+)|\\*)\\s*(\\(\\s*(?<biome>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+|\\*)(\\s*(?<biomeadd>\\+))?\\s*\\))?\\s*(//.*)?)|(?<empty>\\s*)\\s*(//.*)?";
        private static final Pattern rootPattern = Pattern.compile("\\s*(?<palettehead>(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*)(\\s*,\\s*(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*))*\\s*:\\s*(//.*)?)|(?<palettebody>(?<sourceblock>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*)\\s*(?<mappingconditions>\\(\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?(\\s*,\\s*(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?)*\\s*\\s*\\))?\\s*\\s*->\\s*(?<targetblocks>(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?)(\\s*,\\s*(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?))*)\\s*\\s*(//.*)?)|(?<transformation>((?<chance>[0-9.]+)%\\s)?\\s*((?<transformgroup>[A-z_][A-z_0-9]*)?:(?<order>[0-9]+)?\\s)?\\s*(?<palettegroup>[A-z_][A-z_0-9]*)\\s*=>\\s*((?<structure>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+)|\\*)\\s*(\\(\\s*(?<biome>([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.]+|\\*)(\\s*(?<biomeadd>\\+))?\\s*\\))?\\s*(//.*)?)|(?<empty>\\s*)\\s*(//.*)?");
        private static final Pattern conditionPattern = Pattern.compile("(!)?([A-z_\\-/.][A-z_0-9\\-/.]*)(\\s*=\\s*([A-z_0-9\\-/.:]*))?");
        private static final Pattern paletteGroupPattern = Pattern.compile("(([0-9.]+)\\s+)?([A-z_][A-z_0-9]*)");
        private static final Pattern targetBlockPattern = Pattern.compile("(([0-9.]+)%?\\s+)?(([A-z_\\-/.][A-z_0-9\\-/.]*:)?[A-z_\\-/.][A-z_0-9\\-/.]*|%[A-z_][A-z_0-9]*:[A-z_][A-z_0-9]*|\\?)");

        private Parser() {
        }

        public void parse(List<String> lines) throws ConfigParseException {
            for (String line : lines) {
                Matcher matcher = rootPattern.matcher(line);
                if (matcher.matches()) {
                    if (matcher.group("palettehead") != null) {
                        this.parsePaletteHead(matcher.group("palettehead"));
                        continue;
                    }
                    if (matcher.group("palettebody") != null) {
                        this.parsePaletteBody(matcher);
                        continue;
                    }
                    if (matcher.group("transformation") == null) continue;
                    this.parseTransformation(matcher);
                    continue;
                }
                throw new ConfigParseException(line);
            }
            this.addPalette();
        }

        private void parseTransformation(Matcher matcher) {
            this.addPalette();
            this.transformations.add(new TransformEntry(matcher.group("transformgroup"), matcher.group("palettegroup"), matcher.group("chance") != null ? Double.parseDouble(matcher.group("chance")) : 100.0, matcher.group("order") != null ? Integer.parseInt(matcher.group("order")) : 0, matcher.group("structure"), matcher.group("biome"), matcher.group("biomeadd") != null));
        }

        private void parsePaletteBody(Matcher matcher) {
            this.currentPaletteMappings.add(new PaletteEntry.Mapping(matcher.group("sourceblock"), this.parseTargetBlocks(matcher.group("targetblocks")), this.parseConditions(matcher.group("mappingconditions"))));
        }

        private TargetEntry parseTargetBlocks(String targetBlocks) {
            Matcher matcher = targetBlockPattern.matcher(targetBlocks);
            LinkedList<Tuple<Double, String>> targetList = new LinkedList<Tuple<Double, String>>();
            while (matcher.find()) {
                targetList.add((Tuple<Double, String>)new Tuple((Object)(matcher.group(2) != null ? Double.parseDouble(matcher.group(2)) : 1000.0), (Object)matcher.group(3)));
            }
            return new TargetEntry(targetList);
        }

        private List<Condition> parseConditions(String conditions) {
            if (conditions == null) {
                return Collections.emptyList();
            }
            Matcher matcher = conditionPattern.matcher(conditions);
            LinkedList<Condition> conditionList = new LinkedList<Condition>();
            while (matcher.find()) {
                conditionList.add(new Condition(matcher.group(2), matcher.group(4), matcher.group(1) != null));
            }
            return conditionList;
        }

        private void parsePaletteHead(String palettehead) {
            this.addPalette();
            Matcher matcher = paletteGroupPattern.matcher(palettehead);
            this.currentPaletteGroups = new LinkedList<Tuple<Double, String>>();
            while (matcher.find()) {
                this.currentPaletteGroups.add((Tuple<Double, String>)new Tuple((Object)(matcher.group(2) != null ? Double.parseDouble(matcher.group(2)) : 1000.0), (Object)matcher.group(3)));
            }
        }

        private void addPalette() {
            if (this.currentPaletteGroups != null) {
                this.palettes.add(new PaletteEntry(this.currentPaletteGroups, this.currentPaletteMappings));
                this.currentPaletteGroups = null;
                this.currentPaletteMappings = new LinkedList<PaletteEntry.Mapping>();
            }
        }

        public Config getConfig() {
            return new Config(this.transformations, this.palettes);
        }
    }

    public static class ConfigParseException
    extends Exception {
        public ConfigParseException(String line) {
            super("Invalid config line: " + line);
        }
    }
}

