/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.mixin;

import io.github.orlouge.structurepalettes.interfaces.HasModifiedBiomeList;
import io.github.orlouge.structurepalettes.transformers.StructureTransformerManager;
import java.util.LinkedList;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChunkGenerator.class})
public class ChunkGeneratorMixin {
    @ModifyVariable(method={"trySetStructureStart(Lnet/minecraft/structure/StructureSet$WeightedEntry;Lnet/minecraft/world/gen/StructureAccessor;Lnet/minecraft/registry/DynamicRegistryManager;Lnet/minecraft/world/gen/noise/NoiseConfig;Lnet/minecraft/structure/StructureTemplateManager;JLnet/minecraft/world/chunk/Chunk;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/util/math/ChunkSectionPos;)Z"}, at=@At(value="STORE"))
    public HolderSet<Biome> modifyStructureBiomes(HolderSet<Biome> biomes, StructureSet.StructureSelectionEntry weightedEntry, StructureManager structureAccessor, RegistryAccess dynamicRegistryManager) {
        HasModifiedBiomeList modifiedBiomes;
        Structure structure = (Structure)weightedEntry.f_210026_().m_203334_();
        if (structure instanceof HasModifiedBiomeList && (modifiedBiomes = (HasModifiedBiomeList)structure).getModifiedBiomeList() == null) {
            HolderSet.Direct entryList;
            ResourceLocation structureId = ((ResourceKey)weightedEntry.f_210026_().m_203543_().get()).m_135782_();
            LinkedList entries = new LinkedList();
            boolean[] modified = new boolean[]{false};
            for (ResourceLocation biomeId : StructureTransformerManager.getAdditionalBiomes(structureId)) {
                ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeId);
                dynamicRegistryManager.m_175515_(Registries.f_256952_).m_203636_(biomeKey).ifPresent(entry -> {
                    entries.add(entry);
                    modified[0] = true;
                });
            }
            if (modified[0]) {
                entries.addAll(biomes.m_203614_().toList());
                entryList = HolderSet.m_205800_(entries);
            } else {
                entryList = biomes;
            }
            modifiedBiomes.setModifiedBiomeList((HolderSet<Biome>)entryList);
            return entryList;
        }
        return biomes;
    }
}

