/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.mixin;

import io.github.orlouge.structurepalettes.transformers.StructureTransformer;
import io.github.orlouge.structurepalettes.transformers.StructureTransformerManager;
import io.github.orlouge.structurepalettes.transformers.StructureTransformerProvider;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ConfiguredFeature.class})
public abstract class ConfiguredFeatureMixin
implements StructureTransformerProvider {
    private StructureTransformerManager.Pool structureTransformerPool = null;

    @Override
    public StructureTransformer getStructureTransformer(ResourceLocation featureIdentifier, Holder<Biome> biome, RandomSource rng) {
        if (this.structureTransformerPool == null) {
            this.structureTransformerPool = StructureTransformerManager.getPool(featureIdentifier);
        }
        StructureTransformer transformer = this.structureTransformerPool.sample(biome, rng);
        if (biome != null) {
            return biome.m_203543_().map(k -> transformer.withContext(ctx -> {
                ctx.biome = k.m_135782_();
            })).orElse(transformer);
        }
        return transformer;
    }
}

