/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.mixin;

import io.github.orlouge.structurepalettes.interfaces.HasModifiedBiomeList;
import io.github.orlouge.structurepalettes.transformers.StructureTransformer;
import io.github.orlouge.structurepalettes.transformers.StructureTransformerManager;
import io.github.orlouge.structurepalettes.transformers.StructureTransformerProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public class StructureMixin
implements StructureTransformerProvider,
HasModifiedBiomeList {
    private StructureTransformerManager.Pool structureTransformerPool = null;
    private HolderSet<Biome> modifiedBiomeList = null;

    @Override
    public StructureTransformer getStructureTransformer(ResourceLocation structureIdentifier, Holder<Biome> biome, RandomSource rng) {
        if (this.structureTransformerPool == null) {
            this.structureTransformerPool = StructureTransformerManager.getPool(structureIdentifier);
        }
        StructureTransformer transformer = this.structureTransformerPool.sample(biome, rng);
        if (biome != null) {
            return biome.m_203543_().map(k -> transformer.withContext(ctx -> {
                ctx.biome = k.m_135782_();
            })).orElse(transformer);
        }
        return transformer;
    }

    @Override
    public HolderSet<Biome> getModifiedBiomeList() {
        return this.modifiedBiomeList;
    }

    @Override
    public void setModifiedBiomeList(HolderSet<Biome> modifiedBiomeList) {
        this.modifiedBiomeList = modifiedBiomeList;
    }

    @Inject(method={"getValidBiomes()Lnet/minecraft/registry/entry/RegistryEntryList;"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetBiomes(CallbackInfoReturnable<HolderSet<Biome>> cir) {
        if (this.modifiedBiomeList != null) {
            cir.setReturnValue(this.modifiedBiomeList);
            cir.cancel();
        }
    }
}

