/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.palettes;

import io.github.orlouge.structurepalettes.config.Condition;
import io.github.orlouge.structurepalettes.config.PaletteEntry;
import io.github.orlouge.structurepalettes.palettes.MappingContext;
import io.github.orlouge.structurepalettes.palettes.TargetBlock;
import io.github.orlouge.structurepalettes.palettes.VirtualIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class Palette {
    private final Map<ResourceLocation, List<Mapping>> replacements;
    private final Map<VirtualIdentifier, List<Mapping>> references;

    public Palette(Map<ResourceLocation, List<Mapping>> replacements, Map<VirtualIdentifier, List<Mapping>> references) {
        this.replacements = replacements;
        this.references = references;
    }

    public static Palette fromEntry(PaletteEntry paletteEntry, String group) {
        Palette palette = new Palette(new HashMap<ResourceLocation, List<Mapping>>(), new HashMap<VirtualIdentifier, List<Mapping>>());
        for (PaletteEntry.Mapping entry : paletteEntry.mappings) {
            TargetBlock target = TargetBlock.fromEntry(entry.target);
            Mapping mapping = new Mapping(target, entry.conditions);
            if (VirtualIdentifier.isVirtual(entry.source)) {
                palette.references.computeIfAbsent(new VirtualIdentifier(group, entry.source), k -> new LinkedList()).add(mapping);
                continue;
            }
            palette.replacements.computeIfAbsent(new ResourceLocation(entry.source), k -> new LinkedList()).add(mapping);
        }
        return palette;
    }

    public ResourceLocation transform(ResourceLocation id, MappingContext context, RandomSource rng) {
        List mappings = this.replacements.getOrDefault(id, Collections.emptyList());
        for (Mapping mapping : mappings) {
            if (!mapping.matches(context)) continue;
            return (ResourceLocation)mapping.target.sample(rng).map(rid -> rid, vid -> this.locate((VirtualIdentifier)vid, context, rng));
        }
        return null;
    }

    public ResourceLocation locate(VirtualIdentifier id, MappingContext context, RandomSource rng) {
        List mappings = this.references.getOrDefault(id, Collections.emptyList());
        for (Mapping mapping : mappings) {
            if (!mapping.matches(context)) continue;
            return (ResourceLocation)mapping.target.sample(rng).map(rid -> rid, vid -> this.locate((VirtualIdentifier)vid, context, rng));
        }
        return null;
    }

    public boolean disjoint(Palette other) {
        return Collections.disjoint(this.replacements.keySet(), other.replacements.keySet()) && Collections.disjoint(this.references.keySet(), other.references.keySet());
    }

    public void merge(Palette other) {
        this.references.putAll(other.references);
        this.replacements.putAll(other.replacements);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ResourceLocation, List<Mapping>> entry : this.replacements.entrySet()) {
            for (Mapping mapping : entry.getValue()) {
                builder.append(entry.getKey().toString());
                builder.append(" -> ");
                builder.append(mapping.toString());
                builder.append("\n");
            }
        }
        for (Map.Entry<Object, List<Mapping>> entry : this.references.entrySet()) {
            for (Mapping mapping : entry.getValue()) {
                builder.append(((VirtualIdentifier)entry.getKey()).toString());
                builder.append(" -> ");
                builder.append(mapping.toString());
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public int size() {
        return this.references.size() + this.replacements.size();
    }

    private static class Mapping {
        private final TargetBlock target;
        private boolean mustBeFeature = false;
        private boolean mustNotBeFeature = false;
        private ResourceLocation featureId = null;
        private boolean mustBePiece = false;
        private boolean mustNotBePiece = false;
        private ResourceLocation pieceId = null;
        private boolean mustBePoolElement = false;
        private boolean mustNotBePoolElement = false;
        private ResourceLocation poolElementId = null;
        private ResourceLocation biomeId = null;

        public Mapping(TargetBlock target, Collection<Condition> conditions) {
            this.target = target;
            for (Condition condition : conditions) {
                if (condition.key.equals("feature")) {
                    if (condition.negate) {
                        this.mustNotBeFeature = true;
                        continue;
                    }
                    this.mustBeFeature = true;
                    this.featureId = condition.value == null ? null : new ResourceLocation(condition.value);
                    continue;
                }
                if (condition.key.equals("piece")) {
                    if (condition.negate) {
                        this.mustNotBePiece = true;
                        continue;
                    }
                    this.mustBePiece = true;
                    this.pieceId = condition.value == null ? null : new ResourceLocation(condition.value);
                    continue;
                }
                if (condition.key.equals("biome")) {
                    this.biomeId = new ResourceLocation(condition.value);
                    continue;
                }
                if (!condition.key.equals("poolelement")) continue;
                if (condition.negate) {
                    this.mustNotBePoolElement = true;
                    continue;
                }
                this.mustBePoolElement = true;
                this.poolElementId = condition.value == null ? null : new ResourceLocation(condition.value);
            }
        }

        public boolean matches(MappingContext context) {
            if (this.mustBeFeature) {
                if (context.feature == null) {
                    return false;
                }
                if (this.featureId != null && !context.feature.equals((Object)this.featureId)) {
                    return false;
                }
            }
            if (this.mustNotBeFeature && context.feature != null) {
                return false;
            }
            if (this.mustBePiece) {
                if (context.piece == null) {
                    return false;
                }
                if (this.pieceId != null && !context.piece.equals((Object)this.pieceId)) {
                    return false;
                }
            }
            if (this.mustNotBePiece && context.piece != null) {
                return false;
            }
            if (!(this.biomeId == null || context.biome != null && context.biome.equals((Object)this.biomeId))) {
                return false;
            }
            if (this.mustBePoolElement) {
                if (context.poolelement == null) {
                    return false;
                }
                if (this.poolElementId != null && !context.poolelement.equals((Object)this.poolElementId)) {
                    return false;
                }
            }
            return !this.mustNotBePoolElement || context.poolelement == null;
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

