/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.palettes;

import io.github.orlouge.structurepalettes.palettes.MappingContext;
import io.github.orlouge.structurepalettes.palettes.Palette;
import io.github.orlouge.structurepalettes.palettes.VirtualIdentifier;
import io.github.orlouge.structurepalettes.utils.WeightedRandomList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;

public class PaletteGroup {
    private final WeightedRandomList<Palette> palettes = new WeightedRandomList();

    public PaletteGroup(Collection<Tuple<Double, Palette>> palettes) {
        for (Tuple<Double, Palette> palette : palettes) {
            this.palettes.add((Double)palette.m_14418_() * (double)((Palette)palette.m_14419_()).size(), (Palette)palette.m_14419_());
        }
    }

    private Palette samplePalette() {
        return new PaletteGroupSampler(this);
    }

    public static Palette samplePalette(String rootGroup, Map<String, PaletteGroup> groups) {
        return new PaletteSampler(rootGroup, groups);
    }

    private static class PaletteGroupSampler
    extends Palette {
        private final WeightedRandomList<Palette> unusedPalettes;

        public PaletteGroupSampler(PaletteGroup group) {
            super(new HashMap<ResourceLocation, List<Palette.Mapping>>(), new HashMap<VirtualIdentifier, List<Palette.Mapping>>());
            this.unusedPalettes = group != null ? new WeightedRandomList<Palette>(group.palettes) : new WeightedRandomList();
        }

        private Palette sampleMerge(RandomSource rng) {
            Palette newSample = this.unusedPalettes.popSample(rng);
            if (newSample == null) {
                return null;
            }
            if (this.disjoint(newSample)) {
                this.merge(newSample);
            }
            return newSample;
        }

        @Override
        public ResourceLocation transform(ResourceLocation id, MappingContext context, RandomSource rng) {
            ResourceLocation target = super.transform(id, context, rng);
            if (target == null) {
                return this.sampleMerge(rng) == null ? null : this.transform(id, context, rng);
            }
            return target;
        }

        @Override
        public ResourceLocation locate(VirtualIdentifier id, MappingContext context, RandomSource rng) {
            ResourceLocation target = super.locate(id, context, rng);
            if (target == null) {
                return this.sampleMerge(rng) == null ? null : this.locate(id, context, rng);
            }
            return target;
        }
    }

    private static class PaletteSampler
    extends PaletteGroupSampler {
        private final Map<String, PaletteGroup> groups;
        private final String rootGroup;
        private final Map<String, Palette> sampledPalettes;

        private PaletteSampler(String rootGroup, Map<String, PaletteGroup> groups) {
            super(groups.get(rootGroup));
            this.groups = groups;
            this.rootGroup = rootGroup;
            this.sampledPalettes = new HashMap<String, Palette>();
        }

        @Override
        public ResourceLocation transform(ResourceLocation id, MappingContext context, RandomSource rng) {
            return super.transform(id, context, rng);
        }

        @Override
        public ResourceLocation locate(VirtualIdentifier id, MappingContext context, RandomSource rng) {
            if (id.group().equals(this.rootGroup)) {
                return super.locate(id, context, rng);
            }
            Palette palette = this.sampledPalettes.get(id.group());
            if (palette == null) {
                palette = this.groups.get(id.group()).samplePalette();
                this.sampledPalettes.put(id.group(), palette);
            }
            return palette.locate(id, context, rng);
        }
    }
}

