/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.palettes;

import io.github.orlouge.structurepalettes.config.PaletteEntry;
import io.github.orlouge.structurepalettes.palettes.Palette;
import io.github.orlouge.structurepalettes.palettes.PaletteGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;

public class PaletteManager {
    private static final Map<String, PaletteGroup> groups = new HashMap<String, PaletteGroup>();

    public static void load(Collection<PaletteEntry> entries) {
        HashMap<String, List> tmpGroups = new HashMap<String, List>();
        for (PaletteEntry entry : entries) {
            for (Tuple<Double, String> groupEntry : entry.groups) {
                tmpGroups.computeIfAbsent((String)groupEntry.m_14419_(), g -> new LinkedList()).add(new Tuple((Object)((Double)groupEntry.m_14418_()), (Object)Palette.fromEntry(entry, (String)groupEntry.m_14419_())));
            }
        }
        tmpGroups.forEach((g, list) -> groups.put((String)g, new PaletteGroup((Collection<Tuple<Double, Palette>>)list)));
    }

    public static PaletteGroup getGroup(String paletteGroup) {
        return groups.get(paletteGroup);
    }

    public static Palette samplePalette(String rootGroup) {
        return PaletteGroup.samplePalette(rootGroup, groups);
    }
}

