/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.palettes;

import com.mojang.datafixers.util.Either;
import io.github.orlouge.structurepalettes.config.TargetEntry;
import io.github.orlouge.structurepalettes.palettes.VirtualIdentifier;
import io.github.orlouge.structurepalettes.utils.WeightedRandomList;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;

public class TargetBlock {
    private final WeightedRandomList<Either<ResourceLocation, VirtualIdentifier>> targetBlocks = new WeightedRandomList();

    private TargetBlock() {
    }

    public TargetBlock(Collection<Tuple<Double, ResourceLocation>> blocks) {
        for (Tuple<Double, ResourceLocation> entry : blocks) {
            this.targetBlocks.add((Double)entry.m_14418_(), (Either<ResourceLocation, VirtualIdentifier>)Either.left((Object)((ResourceLocation)entry.m_14419_())));
        }
    }

    public static TargetBlock fromEntry(TargetEntry entry) {
        TargetBlock targetBlock = new TargetBlock();
        for (Tuple<Double, String> target : entry.targets) {
            if (((String)target.m_14419_()).equals("?")) {
                targetBlock.targetBlocks.add((Double)target.m_14418_(), (Either<ResourceLocation, VirtualIdentifier>)Either.left(null));
                continue;
            }
            if (VirtualIdentifier.isVirtual((String)target.m_14419_())) {
                targetBlock.targetBlocks.add((Double)target.m_14418_(), (Either<ResourceLocation, VirtualIdentifier>)Either.right((Object)new VirtualIdentifier((String)target.m_14419_())));
                continue;
            }
            targetBlock.targetBlocks.add((Double)target.m_14418_(), (Either<ResourceLocation, VirtualIdentifier>)Either.left((Object)new ResourceLocation((String)target.m_14419_())));
        }
        return targetBlock;
    }

    public Either<ResourceLocation, VirtualIdentifier> sample(RandomSource rng) {
        return this.targetBlocks.sample(rng);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Either<ResourceLocation, VirtualIdentifier> entry : this.targetBlocks) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            builder.append((String)entry.map(id -> id == null ? "?" : id.toString(), id -> id == null ? "?" : id.toString()));
        }
        return builder.toString();
    }
}

