/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.transformers;

import io.github.orlouge.structurepalettes.config.TransformEntry;
import io.github.orlouge.structurepalettes.palettes.MappingContext;
import io.github.orlouge.structurepalettes.palettes.Palette;
import io.github.orlouge.structurepalettes.palettes.PaletteManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public abstract class StructureTransformer {
    public static StructureTransformer fromEntry(TransformEntry entry, RandomSource rng) {
        Palette palette = PaletteManager.samplePalette(entry.paletteGroup);
        if (palette != null) {
            return new Simple(palette, new MappingContext(), rng);
        }
        return new Chain();
    }

    public static StructureTransformer chain(Collection<StructureTransformer> transformer) {
        return new Chain(transformer);
    }

    public abstract BlockState transform(BlockState var1);

    public abstract StructureTransformer withContext(Consumer<MappingContext> var1);

    public abstract boolean isNop();

    private static class Simple
    extends StructureTransformer {
        private final Palette palette;
        private final RandomSource rng;
        private final MappingContext ctx;

        private Simple(Palette palette, MappingContext ctx, RandomSource rng) {
            this.palette = palette;
            this.rng = rng;
            this.ctx = ctx;
        }

        @Override
        public BlockState transform(BlockState state) {
            return state.m_60734_().m_204297_().m_203543_().flatMap(k -> Optional.ofNullable(this.palette.transform(k.m_135782_(), this.ctx, this.rng))).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_6612_(arg_0)).map(newBlock -> newBlock.m_152465_(state)).orElse(state);
        }

        @Override
        public StructureTransformer withContext(Consumer<MappingContext> f) {
            MappingContext newCtx = new MappingContext(this.ctx);
            f.accept(newCtx);
            return new Simple(this.palette, newCtx, this.rng);
        }

        @Override
        public boolean isNop() {
            return false;
        }
    }

    private static class Chain
    extends StructureTransformer {
        private final Collection<StructureTransformer> transformers;

        private Chain() {
            this.transformers = Collections.emptyList();
        }

        private Chain(Collection<StructureTransformer> transformers) {
            this.transformers = transformers;
        }

        @Override
        public BlockState transform(BlockState state) {
            for (StructureTransformer transformer : this.transformers) {
                state = transformer.transform(state);
            }
            return state;
        }

        @Override
        public StructureTransformer withContext(Consumer<MappingContext> f) {
            return new Chain(this.transformers.stream().map(t -> t.withContext(f)).collect(Collectors.toList()));
        }

        @Override
        public boolean isNop() {
            return this.transformers.isEmpty();
        }
    }
}

