/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.transformers;

import io.github.orlouge.structurepalettes.config.TransformEntry;
import io.github.orlouge.structurepalettes.transformers.StructureTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;

public class StructureTransformerManager {
    private static final Collection<TransformEntry> transformEntries = new LinkedList<TransformEntry>();

    public static void load(Collection<TransformEntry> entries) {
        transformEntries.addAll(entries);
    }

    public static Pool getPool(ResourceLocation structureIdentifier) {
        return new Pool(transformEntries.stream().filter(entry -> entry.structure == null || new ResourceLocation(entry.structure).equals((Object)structureIdentifier)).sorted(Comparator.comparing(entry -> entry.order)).collect(Collectors.toList()));
    }

    public static Collection<ResourceLocation> getAdditionalBiomes(ResourceLocation structureIdentifier) {
        return transformEntries.stream().filter(entry -> entry.addToBiomeList && entry.structure != null && new ResourceLocation(entry.structure).equals((Object)structureIdentifier)).map(entry -> new ResourceLocation(entry.biome)).collect(Collectors.toList());
    }

    public static class Pool {
        private final List<List<TransformEntry>> groups = new LinkedList<List<TransformEntry>>();

        public Pool(List<TransformEntry> entries) {
            if (entries.size() > 0) {
                int currentOrder = entries.get((int)0).order;
                int i = 0;
                while (i < entries.size()) {
                    TransformEntry entry;
                    TreeMap<String, List> namedGroups = new TreeMap<String, List>();
                    do {
                        entry = entries.get(i++);
                        if (entry.transformGroup == null || entry.transformGroup.length() == 0) {
                            this.groups.add(List.of(entry));
                            continue;
                        }
                        namedGroups.computeIfAbsent(entry.transformGroup, g -> new LinkedList()).add(entry);
                    } while (entry.order == currentOrder && i < entries.size());
                    this.groups.addAll(namedGroups.values());
                    currentOrder = entry.order;
                }
            }
        }

        public StructureTransformer sample(Holder<Biome> biome, RandomSource rng) {
            return StructureTransformer.chain(this.groups.stream().map(g -> this.sampleTransformGroup((List<TransformEntry>)g, biome, rng)).filter(entry -> entry != null && (double)(rng.m_188501_() * 100.0f) < entry.chance).map(entry -> StructureTransformer.fromEntry(entry, rng)).collect(Collectors.toList()));
        }

        private TransformEntry sampleTransformGroup(List<TransformEntry> entries, Holder<Biome> biome, RandomSource rng) {
            ArrayList<TransformEntry> shuffled = new ArrayList<TransformEntry>(entries);
            Collections.shuffle(shuffled, new Random(rng.m_188502_()));
            for (TransformEntry entry : shuffled) {
                if (entry.biome != null && !biome.m_203373_(new ResourceLocation(entry.biome)) || !((double)(rng.m_188501_() * 100.0f) < entry.chance)) continue;
                return entry;
            }
            return null;
        }
    }
}

