/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.structurepalettes.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.RandomSource;

public class WeightedRandomList<T>
implements Iterable<T> {
    private final TreeMap<Double, T> weightMap;
    private double totalWeight = 0.0;

    public WeightedRandomList() {
        this.weightMap = new TreeMap();
    }

    public WeightedRandomList(WeightedRandomList<T> copyFrom) {
        this.weightMap = (TreeMap)copyFrom.weightMap.clone();
        this.totalWeight = copyFrom.totalWeight;
    }

    public static <T> WeightedRandomList<T> singleton(T entry) {
        WeightedRandomList<T> list = new WeightedRandomList<T>();
        list.add(1.0, entry);
        return list;
    }

    public void add(double weight, T element) {
        this.totalWeight += weight;
        this.weightMap.put(this.totalWeight, element);
    }

    public T sample(RandomSource random) {
        Map.Entry<Double, T> entry = this.weightMap.higherEntry(random.m_188500_() * this.totalWeight);
        return entry != null ? (T)entry.getValue() : null;
    }

    public T popSample(RandomSource random) {
        Map.Entry<Double, T> sample = this.weightMap.size() == 1 ? this.weightMap.firstEntry() : this.weightMap.higherEntry(random.m_188500_() * this.totalWeight);
        if (sample != null) {
            Map.Entry<Double, T> previous = this.weightMap.lowerEntry(sample.getKey());
            double diff = previous == null ? sample.getKey() : sample.getKey() - previous.getKey();
            this.totalWeight -= diff;
            this.weightMap.remove(sample.getKey());
            for (Double entryWeight : this.weightMap.tailMap(sample.getKey(), false).keySet().stream().toList()) {
                T entry = this.weightMap.remove(entryWeight);
                this.weightMap.put(entryWeight - diff, entry);
            }
            return sample.getValue();
        }
        return null;
    }

    public int size() {
        return this.weightMap.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.weightMap.values().iterator();
    }
}

