/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.providers;

import com.google.common.collect.ImmutableList;
import com.legacy.dungeons_plus.data.DPTags;
import com.legacy.dungeons_plus.data.providers.DPLangProvider;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class DPLootProv
extends LootTableProvider {
    public DPLootProv(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(DPBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(DPEntityLoot::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(DPChestLoot::new, LootContextParamSets.f_81411_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.m_79147_();
            pools.forEach(pool -> table.m_79161_(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.m_79147_().m_79161_(pool);
        }

        default public LootPool.Builder basicPool(ItemLike item, int min, int max) {
            return LootPool.m_79043_().m_79076_(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(ItemLike item) {
            return LootPool.m_79043_().m_79076_(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<ItemLike> items) {
            return this.poolOf(items.stream().map((? super T i) -> this.basicEntry((ItemLike)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootPoolEntryContainer.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.m_79043_();
            lootEntries.forEach(entry -> pool.m_79076_(entry));
            return pool;
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item, int min, int max) {
            return this.basicEntry(item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item) {
            return LootItem.m_79579_((ItemLike)item);
        }

        default public LootPoolSingletonContainer.Builder<?> tagEntry(TagKey<Item> tag, int min, int max) {
            return TagEntry.m_205095_(tag).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }

        default public LootPoolSingletonContainer.Builder<?> tagEntry(TagKey<Item> tag, int count) {
            return TagEntry.m_205095_(tag).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)));
        }

        default public LootPoolSingletonContainer.Builder<?> tagEntry(TagKey<Item> tag) {
            return this.tagEntry(tag, 1);
        }

        default public LootItemConditionalFunction.Builder<?> setDamage(int min, int max) {
            return SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)((float)min / 100.0f), (float)((float)max / 100.0f)));
        }

        default public LootItemConditionalFunction.Builder<?> smeltItem(EntityPredicate.Builder predicate) {
            return SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)predicate));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(int minLevel, int maxLevel) {
            return EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)minLevel, (float)maxLevel));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(Enchantment ... enchantments) {
            EnchantRandomlyFunction.Builder builder = EnchantRandomlyFunction.m_165191_();
            for (Enchantment enchantment : enchantments) {
                builder.m_80444_(enchantment);
            }
            return builder;
        }

        default public LootItemConditionalFunction.Builder<?> map(TagKey<Structure> structure) {
            return ExplorationMapFunction.m_80554_().m_210658_(structure).m_80573_(MapDecoration.Type.RED_X).m_80569_((byte)1).m_80575_(false);
        }

        default public LootItemConditionalFunction.Builder<?> mapName(StructureRegistrar<?> structure) {
            return SetNameFunction.m_165457_((Component)Component.m_237115_((String)DPLangProvider.mapName(structure)));
        }

        default public LootItemConditionalFunction.Builder<?> setNbt(Consumer<CompoundTag> nbt) {
            return SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt)));
        }
    }

    private static class DPBlockLoot
    extends BlockLootSubProvider
    implements LootPoolUtil {
        protected DPBlockLoot() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.blocks().forEach(block -> this.m_245724_((Block)block));
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        private Stream<Block> blocks() {
            return BuiltInRegistries.f_256975_.m_123024_().filter(b -> {
                ResourceLocation name = BuiltInRegistries.f_256975_.m_7981_(b);
                return name != null && name.m_135827_().equals("dungeons_plus") && !b.m_60589_().equals((Object)BuiltInLootTables.f_78712_);
            });
        }
    }

    private static class DPEntityLoot
    extends EntityLootSubProvider
    implements LootPoolUtil {
        public DPEntityLoot() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.Tower.ENTITY_ZOMBIE, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20501_.m_20677_()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)))));
            consumer.accept(DPLoot.Tower.ENTITY_SKELETON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20524_.m_20677_()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)))));
            consumer.accept(DPLoot.Tower.ENTITY_SPIDER, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20479_.m_20677_()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)))));
            consumer.accept(DPLoot.ReanimatedRuins.ENTITY_ZOMBIE, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20501_.m_20677_()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f)))));
            consumer.accept(DPLoot.ReanimatedRuins.ENTITY_SKELETON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20524_.m_20677_()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f)))));
            consumer.accept(DPLoot.Leviathan.ENTITY_HUSK, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_41830_, 0, 2).m_79707_(1).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20458_.m_20677_()))))));
            consumer.accept(DPLoot.SnowyTemple.ENTITY_STRAY, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_41980_, 0, 2).m_79707_(128).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))), (Object)this.basicEntry((ItemLike)Items.f_42201_, 0, 2).m_79707_(1).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20481_.m_20677_()))))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return BuiltInRegistries.f_256780_.m_123024_().filter(e -> {
                ResourceLocation name = BuiltInRegistries.f_256780_.m_7981_(e);
                return name != null && name.m_135827_().equals("dungeons_plus");
            });
        }
    }

    private static class DPChestLoot
    implements LootTableSubProvider,
    LootPoolUtil {
        private DPChestLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.tower(consumer);
            this.reanimatedRuins(consumer);
            this.leviathan(consumer);
            this.snowyTemple(consumer);
            this.warpedGarden(consumer);
            this.soulPrison(consumer);
            this.endRuins(consumer);
        }

        private void tower(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.Tower.CHEST_COMMON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42500_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42403_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42583_, 2, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42401_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42402_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42484_, 1, 2).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_TOWER_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42749_, 1, 3).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42451_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42534_, 2, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42417_, 1, 2).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_TOWER_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42014_, 1, 3).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42517_, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42584_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42450_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42656_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.tagEntry(DPTags.Items.LOOT_TOWER_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))));
            consumer.accept(DPLoot.Tower.CHEST_BARREL, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42501_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42446_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42589_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43599_)), (Object)this.basicEntry((ItemLike)Items.f_42405_, 1, 4).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42398_, 2, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42420_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42749_, 2, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42594_, 2, 4).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42399_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_41953_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_41952_, 2, 3).m_79707_(2), (Object[])new LootPoolEntryContainer.Builder[0])).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))));
            consumer.accept(DPLoot.Tower.CHEST_VEX, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42402_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42749_, 4, 9).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42416_, 1, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_41828_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42454_, 1, 3).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_TOWER_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42654_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42417_, 2, 4).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42714_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42386_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42386_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42384_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42387_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42385_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42383_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_151059_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42049_, 2, 3).m_79707_(4), (Object)this.tagEntry(DPTags.Items.LOOT_TOWER_RARE), (Object[])new LootPoolEntryContainer.Builder[0])).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))));
            consumer.accept(DPLoot.Tower.CHEST_VEX_MAP, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42676_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.map(DPTags.Structures.ON_REANIMATED_RUINS_MAPS)).m_79078_((LootItemFunction.Builder)this.mapName(DPStructures.REANIMATED_RUINS)))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.Tower.CHEST_VEX))))));
        }

        private void reanimatedRuins(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_COMMON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42500_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42403_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42583_, 2, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42401_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42402_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42018_, 3, 5).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42749_, 1, 3).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42451_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42784_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42587_, 2, 4).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42584_, 0, 1).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42450_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42656_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))));
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_DESERT, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_41830_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42500_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42583_, 1, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_41866_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42587_, 2, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42416_, 1, 3).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_41831_, 2, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42590_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42417_, 2, 4).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42451_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42413_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42384_).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42436_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42446_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(5).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42587_).m_79707_(5), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))));
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_DESERT_MAP, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42676_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.map(DPTags.Structures.ON_LEVIATHAN_MAPS)).m_79078_((LootItemFunction.Builder)this.mapName(DPStructures.LEVIATHAN)))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.ReanimatedRuins.CHEST_DESERT))))));
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_FROZEN, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42412_, 1, 5).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42500_, 2, 5).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42452_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42484_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42402_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42401_, 1, 2).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_41980_, 2, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42738_, 2, 4).m_79707_(4).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43615_)), (Object)this.basicEntry((ItemLike)Items.f_42416_, 2, 4).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42451_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42413_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42411_).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42411_).m_79707_(2).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42465_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(5).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42711_).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))));
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_FROZEN_MAP, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42676_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.map(DPTags.Structures.ON_SNOWY_TEMPLE_MAPS)).m_79078_((LootItemFunction.Builder)this.mapName(DPStructures.SNOWY_TEMPLE)))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.ReanimatedRuins.CHEST_FROZEN))))));
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_MOSSY, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42583_, 1, 5).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_151079_, 2, 5).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_151019_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_151051_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42461_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42401_, 1, 2).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_151016_, 2, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42518_, 2, 4).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42587_, 1, 4).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_151051_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42413_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42449_).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_150996_, 0, 2).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42447_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(2).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42385_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[]{Enchantments.f_44984_, Enchantments.f_44986_, Enchantments.f_44985_, Enchantments.f_44963_})).m_79078_((LootItemFunction.Builder)this.setDamage(10, 60)), (Object)this.tagEntry(DPTags.Items.LOOT_REANIMATED_RUINS_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))));
            consumer.accept(DPLoot.ReanimatedRuins.CHEST_MOSSY_MAP, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42676_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.map(DPTags.Structures.ON_WARPED_GARDEN_MAPS)).m_79078_((LootItemFunction.Builder)this.mapName(DPStructures.WARPED_GARDEN)))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.ReanimatedRuins.CHEST_MOSSY))))));
        }

        private void leviathan(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.Leviathan.CHEST_COMMON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42500_, 1, 2).m_79707_(10), (Object)this.basicEntry((ItemLike)Items.f_42649_, 1, 2).m_79707_(10), (Object)this.basicEntry((ItemLike)Items.f_42583_, 1, 5).m_79707_(10), (Object)this.basicEntry((ItemLike)Items.f_42587_).m_79707_(10), (Object)this.basicEntry((ItemLike)Items.f_41830_, 1, 2).m_79707_(10), (Object)this.basicEntry((ItemLike)Items.f_41866_).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_LEVIATHAN_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42692_, 1, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42534_, 1, 5).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42417_, 2, 4).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 3).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42431_).m_79707_(3).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.tagEntry(DPTags.Items.LOOT_LEVIATHAN_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42436_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42612_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42652_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42656_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(3).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.tagEntry(DPTags.Items.LOOT_LEVIATHAN_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))));
            consumer.accept(DPLoot.Leviathan.CHEST_RARE, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)DPItems.LEVIATHAN_BLADE.get()).m_79707_(1))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.Leviathan.CHEST_COMMON))))));
        }

        private void snowyTemple(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.SnowyTemple.CHEST_COMMON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_41980_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42452_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42412_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42500_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42484_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42402_, 1, 2).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_SNOWY_TEMPLE_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42201_, 1, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42738_, 2, 4).m_79707_(2).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43615_)), (Object)this.basicEntry((ItemLike)Items.f_42416_, 1, 3).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42534_, 1, 3).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42411_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_151055_, 1, 2).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_SNOWY_TEMPLE_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42612_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42465_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42466_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(3).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42463_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[]{Enchantments.f_44974_, Enchantments.f_44986_, Enchantments.f_44963_})), (Object)this.tagEntry(DPTags.Items.LOOT_SNOWY_TEMPLE_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))));
            consumer.accept(DPLoot.SnowyTemple.CHEST_RARE, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)DPItems.FROSTED_COWL.get()).m_79707_(1))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.SnowyTemple.CHEST_COMMON))))));
        }

        private void warpedGarden(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.WarpedGarden.CHEST_COMMON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42583_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_41957_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_41955_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42587_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42692_, 1, 3).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_WARPED_GARDEN_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42048_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42589_, 1, 3).m_79707_(1).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43599_)), (Object)this.basicEntry((ItemLike)Items.f_42355_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42447_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42417_, 1, 3).m_79707_(3), (Object)this.tagEntry(DPTags.Items.LOOT_WARPED_GARDEN_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42715_).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_41836_, 5, 11).m_79707_(10), (Object)this.basicEntry((ItemLike)Items.f_42529_).m_79707_(7), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(5).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42437_).m_79707_(1), (Object)this.tagEntry(DPTags.Items.LOOT_WARPED_GARDEN_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))));
            consumer.accept(DPLoot.WarpedGarden.CHEST_RARE, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)DPItems.WARPED_AXE.get()).m_79707_(1))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.WarpedGarden.CHEST_COMMON))))));
        }

        private void soulPrison(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(DPLoot.SoulPrison.CHEST_COMMON, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42500_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42412_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42613_, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42417_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42403_, 1, 2).m_79707_(2), (Object)this.tagEntry(DPTags.Items.LOOT_SOUL_PRISON_COMMON, 1, 3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42432_).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42779_, 1, 2).m_79707_(1).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43599_)), (Object)this.basicEntry((ItemLike)Items.f_42050_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42054_, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42262_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42586_, 1, 2).m_79707_(3), (Object)this.tagEntry(DPTags.Items.LOOT_SOUL_PRISON_UNCOMMON, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f)), (Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42415_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42710_).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(4).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42677_, 2, 4).m_79707_(5), (Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.SoulPrison.CHEST_GOLDEN_ARMOR))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))));
            consumer.accept(DPLoot.SoulPrison.CHEST_GOLDEN_ARMOR, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42476_).m_79707_(2).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[]{Enchantments.f_44968_, Enchantments.f_44966_, Enchantments.f_44986_})), (Object)this.basicEntry((ItemLike)Items.f_42477_).m_79707_(2).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[]{Enchantments.f_44968_, Enchantments.f_44966_, Enchantments.f_44986_})), (Object)this.basicEntry((ItemLike)Items.f_42476_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.basicEntry((ItemLike)Items.f_42477_).m_79707_(1).m_79078_((LootItemFunction.Builder)this.enchant(new Enchantment[0])), (Object)this.tagEntry(DPTags.Items.LOOT_SOUL_PRISON_RARE))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))));
            consumer.accept(DPLoot.SoulPrison.CHEST_RARE, this.tableOf((List)ImmutableList.of((Object)this.poolOf((List)ImmutableList.of((Object)this.basicEntry((ItemLike)DPItems.SOUL_CANNON.get()).m_79707_(1))), (Object)this.poolOf((List)ImmutableList.of((Object)LootTableReference.m_79776_((ResourceLocation)DPLoot.SoulPrison.CHEST_COMMON))))));
        }

        private void endRuins(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        }
    }
}

