/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.entities;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.registry.DPDamageSource;
import com.legacy.dungeons_plus.registry.DPEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SoulFireballEntity
extends Fireball {
    private static final int DEFAULT_FUSE = 20;
    private int explosionPower = 1;
    private boolean hasFlame = false;
    private boolean isMulti = false;
    private int knockbackPower = 0;
    private int fuse = 20;
    private static final String POWER_KEY = "power";
    private static final String FUSE_KEY = "fuse";
    private static final String HAS_FLAME_KEY = "has_flame";
    private static final String IS_MULTI = "is_multi";
    private static final String KNOCKBACK_KEY = "knockback";

    public SoulFireballEntity(EntityType<? extends SoulFireballEntity> type, Level level) {
        super(type, level);
    }

    public SoulFireballEntity(Level level, LivingEntity owner, double dx, double dy, double dz, int power) {
        super((EntityType)DPEntityTypes.SOUL_FIREBALL.get(), owner, dx, dy, dz, level);
        this.explosionPower = power;
    }

    public SoulFireballEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends SoulFireballEntity>)((EntityType)DPEntityTypes.SOUL_FIREBALL.get()), level);
    }

    public void setKnockback(int knockbackLevel) {
        this.knockbackPower = knockbackLevel;
    }

    public void setIsMultishot(boolean isMulti) {
        this.isMulti = isMulti;
        this.explosionPower = isMulti ? 0 : this.explosionPower;
    }

    public void setHasFlame(boolean hasFlame) {
        this.hasFlame = hasFlame;
    }

    protected void m_6532_(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity hitEntity = entityHitResult.m_82443_();
            if (hitEntity == this.m_37282_() && this.f_19797_ < 5) {
                return;
            }
            if (hitEntity instanceof SoulFireballEntity && this.isMulti) {
                return;
            }
        }
        super.m_6532_(hitResult);
        this.explode();
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.f_19853_.f_46443_) {
            Entity target = hitResult.m_82443_();
            Entity owner = this.m_37282_();
            float damage = this.isMulti ? 6.0f + this.f_19796_.m_188501_() * 2.0f : 2.0f;
            target.m_6469_(DPDamageSource.fireballExplosion(this, owner), damage);
            if (this.hasFlame) {
                target.m_20254_(3);
            }
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                this.m_19970_(livingOwner, target);
            }
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        Entity owner = this.m_37282_();
        Entity damager = damageSource.m_7639_();
        if (damager != owner || owner == null && damager == null) {
            this.fuse = 20;
            this.explosionPower = Math.min(this.explosionPower + 1, 8);
            return super.m_6469_(damageSource, damage);
        }
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123745_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.fuse <= 0) {
            this.explode();
        }
        --this.fuse;
    }

    private void explode() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionPower, false, Level.ExplosionInteraction.NONE);
            if (this.knockbackPower > 0) {
                double k = (double)this.knockbackPower * 0.2 + 1.0;
                double r = this.isMulti ? 2.0 : 4.0;
                Vec3 range = new Vec3(r, r, r);
                Vec3 pos = this.m_20182_();
                for (Entity e : this.f_19853_.m_45976_(Entity.class, new AABB(pos.m_82546_(range), pos.m_82549_(range)))) {
                    double d;
                    if (e instanceof SoulFireballEntity) continue;
                    if (e instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)e;
                        d = ProtectionEnchantment.m_45135_((LivingEntity)living, (double)k);
                    } else {
                        d = k;
                    }
                    double knockback = d;
                    Vec3 motion = pos.m_82492_(0.0, 1.0, 0.0).m_82546_(e.m_20182_()).m_82541_().m_82490_(-knockback);
                    e.m_20334_(0.0, 0.0, 0.0);
                    e.m_20334_(motion.f_82479_, 0.35 * (double)this.knockbackPower, motion.f_82481_);
                    if (!(e instanceof Player)) continue;
                    e.f_19864_ = true;
                }
            }
            if (this.hasFlame && ((Boolean)DPConfig.COMMON.soulCannonProducesFire.get()).booleanValue()) {
                BlockPos p = this.m_20183_();
                if (this.f_19853_.m_8055_(p).m_60795_() && this.f_19853_.m_8055_(p.m_7495_()).m_60804_((BlockGetter)this.f_19853_, p.m_7495_())) {
                    this.f_19853_.m_46597_(p, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)p));
                }
                int fireRange = this.isMulti ? 1 : 2;
                for (BlockPos bPos : BlockPos.m_121925_((BlockPos)p, (int)fireRange, (int)fireRange, (int)fireRange)) {
                    if (this.f_19796_.m_188503_(10) != 0 || !this.f_19853_.m_8055_(bPos).m_60795_() || !this.f_19853_.m_8055_(bPos.m_7495_()).m_60804_((BlockGetter)this.f_19853_, bPos.m_7495_())) continue;
                    this.f_19853_.m_46597_(bPos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)bPos));
                }
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.isMulti ? 5 : 15, 0.0, 0.0, 0.0, this.isMulti ? 0.07 : 0.2);
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_(POWER_KEY, (byte)this.explosionPower);
        tag.m_128405_(FUSE_KEY, this.fuse);
        tag.m_128379_(HAS_FLAME_KEY, this.hasFlame);
        tag.m_128379_(IS_MULTI, this.isMulti);
        tag.m_128405_(KNOCKBACK_KEY, this.knockbackPower);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_(POWER_KEY, 1)) {
            this.explosionPower = tag.m_128445_(POWER_KEY);
        }
        if (tag.m_128425_(FUSE_KEY, 3)) {
            this.fuse = tag.m_128451_(FUSE_KEY);
        }
        if (tag.m_128425_(HAS_FLAME_KEY, 1)) {
            this.hasFlame = tag.m_128471_(HAS_FLAME_KEY);
        }
        if (tag.m_128425_(IS_MULTI, 1)) {
            this.isMulti = tag.m_128471_(IS_MULTI);
        }
        if (tag.m_128425_(KNOCKBACK_KEY, 3)) {
            this.knockbackPower = tag.m_128451_(KNOCKBACK_KEY);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

