/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.registry;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.ItemStack;

public interface DPDamageSource {
    public static final DamageSource CONSUME_SOUL = new DamageSource(DPDamageSource.name("consume_soul")).m_19380_().m_19382_();

    public static DamageSource warpedAxe(Entity damageCauser, @Nullable Entity thrower, @Nullable ItemStack axe) {
        return new ThrownItemDamageSource(DPDamageSource.name("warped_axe"), damageCauser, thrower, axe).m_19366_();
    }

    public static DamageSource fireballExplosion(Fireball fireball, @Nullable Entity shooter) {
        return shooter == null ? new IndirectEntityDamageSource("explosion.player", (Entity)fireball, (Entity)fireball).m_19375_().m_19366_() : new IndirectEntityDamageSource("explosion", (Entity)fireball, shooter).m_19375_().m_19366_();
    }

    private static String name(String key) {
        return "dungeons_plus." + key;
    }

    public static class ThrownItemDamageSource
    extends IndirectEntityDamageSource {
        @Nullable
        private final ItemStack thrownItem;

        public ThrownItemDamageSource(String key, Entity directEntity, @Nullable Entity owner, @Nullable ItemStack thrownItem) {
            super(key, directEntity, owner);
            this.thrownItem = thrownItem;
        }

        public Component m_6157_(LivingEntity killedEntity) {
            Component attackerName = this.m_7639_() == null ? this.f_19391_.m_5446_() : this.m_7639_().m_5446_();
            ItemStack stack = this.thrownItem == null ? ItemStack.f_41583_ : this.thrownItem;
            String msg = "death.attack." + this.f_19326_;
            String msgWithItem = msg + ".item";
            return !stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)msgWithItem, (Object[])new Object[]{killedEntity.m_5446_(), attackerName, stack.m_41611_()}) : Component.m_237110_((String)msg, (Object[])new Object[]{killedEntity.m_5446_(), attackerName});
        }
    }
}

