/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.registry;

import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.structure_gel.api.block_entity.SpawnerAccessHelper;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.events.RegisterDynamicSpawnerEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DPSpawners {
    private static List<DynamicSpawnerType> objs = new ArrayList<DynamicSpawnerType>();
    public static final Optional<SpawnData.CustomSpawnRules> SPAWN_IN_SKYLIGHT = Optional.of(new SpawnData.CustomSpawnRules(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7)), new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15))));
    public static final Optional<SpawnData.CustomSpawnRules> SPAWN_IN_PARTIAL_DARK = Optional.of(new SpawnData.CustomSpawnRules(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7)), new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7))));
    private static final float DROP_CHANCE = 0.085f;
    public static final DynamicSpawnerType TOWER_ZOMBIE = DPSpawners.create("tower_zombie", DPSpawners::towerZombie);
    public static final DynamicSpawnerType TOWER_SKELETON = DPSpawners.create("tower_skeleton", DPSpawners::towerSkeleton);
    public static final DynamicSpawnerType TOWER_SPIDER = DPSpawners.create("tower_spider", DPSpawners::towerSpider);
    public static final DynamicSpawnerType TOWER_VEX = DPSpawners.create("tower_vex", DPSpawners::towerVex);
    public static final DynamicSpawnerType REANIMATED_RUINS_MOSSY = DPSpawners.create("reanimated_ruins_mossy", DPSpawners::reanRuinsMossy);
    public static final DynamicSpawnerType REANIMATED_RUINS_DESERT = DPSpawners.create("reanimated_ruins_desert", DPSpawners::reanRuinsMesa);
    public static final DynamicSpawnerType REANIMATED_RUINS_FROZEN = DPSpawners.create("reanimated_ruins_frozen", DPSpawners::reanRuinsFrozen);
    public static final DynamicSpawnerType LEVIATHAN_HUSK = DPSpawners.create("leviathan_husk", DPSpawners::leviathanHusk);
    public static final DynamicSpawnerType SNOWY_TEMPLE_STRAY = DPSpawners.create("snowy_temple_stray", DPSpawners::snowyTempleStray);
    public static final DynamicSpawnerType WARPED_GARDEN_DROWNED = DPSpawners.create("warped_garden_drowned", DPSpawners::warpedGardenDrowned);
    public static final DynamicSpawnerType SOUL_PRISON_GHAST = DPSpawners.create("soul_prison_ghast", DPSpawners::soulPrisonGhast);
    public static final DynamicSpawnerType END_RUINS_ENDERMAN = DPSpawners.create("end_ruins_enderman", DPSpawners::endRuinsEnderman);
    public static final DynamicSpawnerType END_RUINS_PHANTOM = DPSpawners.create("end_ruins_phantom", DPSpawners::endRuinsPhantom);

    @SubscribeEvent
    protected static void registerDynamicSpawners(RegisterDynamicSpawnerEvent event) {
        objs.forEach(arg_0 -> ((RegisterDynamicSpawnerEvent)event).register(arg_0));
        objs = null;
    }

    private static DynamicSpawnerType create(String name, DynamicSpawnerType.SpawnerModifier spawnerModifier) {
        DynamicSpawnerType dynSpawner = new DynamicSpawnerType(DungeonsPlus.locate(name), spawnerModifier);
        objs.add(dynSpawner);
        return dynSpawner;
    }

    private static void towerZombie(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SpawnData[])new SpawnData[]{DPSpawners.basicMob(s, level, pos, EntityType.f_20501_, DPLoot.Tower.ENTITY_ZOMBIE, SPAWN_IN_SKYLIGHT)});
    }

    private static void towerSkeleton(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SpawnData[])new SpawnData[]{DPSpawners.basicMob(s, level, pos, EntityType.f_20524_, DPLoot.Tower.ENTITY_SKELETON, SPAWN_IN_SKYLIGHT, tag -> DPSpawners.handItems(tag, new ItemStack((ItemLike)Items.f_42411_), 0.085f))});
    }

    private static void towerSpider(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SpawnData[])new SpawnData[]{DPSpawners.basicMob(s, level, pos, EntityType.f_20479_, DPLoot.Tower.ENTITY_SPIDER, SPAWN_IN_SKYLIGHT)});
    }

    private static void towerVex(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnData spawnData = SpawnerAccessHelper.createSpawnerEntity((EntityType)EntityType.f_20491_, (CompoundTag)new CompoundTag(), SPAWN_IN_SKYLIGHT);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SpawnData[])new SpawnData[]{spawnData});
        SpawnerAccessHelper.setMinSpawnDelay((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)100);
        SpawnerAccessHelper.setMaxSpawnDelay((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)400);
        SpawnerAccessHelper.setSpawnCount((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)2);
    }

    private static void reanRuinsMossy(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20501_, DPLoot.ReanimatedRuins.ENTITY_ZOMBIE, SPAWN_IN_PARTIAL_DARK), 2);
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20562_, null, SPAWN_IN_PARTIAL_DARK, tag -> DPSpawners.handItems(tag, new ItemStack((ItemLike)Items.f_42425_), 0.085f, ItemStack.f_41583_, 0.085f)), 1);
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20526_, null, SPAWN_IN_PARTIAL_DARK, tag -> tag.m_128405_("Size", 2)), 1);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SimpleWeightedRandomList)builder.m_146270_());
        SpawnerAccessHelper.setSpawnCount((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)3);
    }

    private static void reanRuinsMesa(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20501_, DPLoot.ReanimatedRuins.ENTITY_ZOMBIE, Optional.empty()), 2);
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20458_, null, Optional.empty()), 2);
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20524_, DPLoot.ReanimatedRuins.ENTITY_SKELETON, Optional.empty(), tag -> DPSpawners.handItems(tag, new ItemStack((ItemLike)Items.f_42432_), 0.085f)), 1);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SimpleWeightedRandomList)builder.m_146270_());
        SpawnerAccessHelper.setSpawnCount((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)3);
    }

    private static void reanRuinsFrozen(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20524_, DPLoot.ReanimatedRuins.ENTITY_SKELETON, Optional.empty(), tag -> DPSpawners.handItems(tag, new ItemStack((ItemLike)Items.f_42411_), 0.085f)), 3);
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20481_, null, Optional.empty()), 2);
        builder.m_146271_((Object)DPSpawners.basicMob(s, level, pos, EntityType.f_20554_, null, Optional.empty()), 1);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SimpleWeightedRandomList)builder.m_146270_());
        SpawnerAccessHelper.setSpawnCount((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)3);
    }

    private static void leviathanHusk(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        DPSpawners.lootTable(tag, DPLoot.Leviathan.ENTITY_HUSK);
        SpawnData spawnData = SpawnerAccessHelper.createSpawnerEntity((EntityType)EntityType.f_20458_, (CompoundTag)tag, SPAWN_IN_SKYLIGHT);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SpawnData[])new SpawnData[]{spawnData});
    }

    private static void snowyTempleStray(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        CompoundTag bowTag = new CompoundTag();
        DPSpawners.lootTable(bowTag, DPLoot.SnowyTemple.ENTITY_STRAY);
        DPSpawners.handItems(bowTag, Items.f_42411_.m_7968_(), 0.085f);
        SpawnData strayBow = SpawnerAccessHelper.createSpawnerEntity((EntityType)EntityType.f_20481_, (CompoundTag)bowTag, SPAWN_IN_SKYLIGHT);
        CompoundTag swordTag = new CompoundTag();
        DPSpawners.lootTable(swordTag, DPLoot.SnowyTemple.ENTITY_STRAY);
        DPSpawners.handItems(swordTag, Items.f_42383_.m_7968_(), 0.085f);
        SpawnData straySword = SpawnerAccessHelper.createSpawnerEntity((EntityType)EntityType.f_20481_, (CompoundTag)swordTag, SPAWN_IN_SKYLIGHT);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SpawnData[])new SpawnData[]{strayBow, straySword});
    }

    private static void warpedGardenDrowned(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SimpleWeightedRandomList.Builder spawns = new SimpleWeightedRandomList.Builder();
        ItemStack goldAxe = new ItemStack((ItemLike)Items.f_42433_);
        goldAxe.m_41721_(10);
        CompoundTag entityTag = new CompoundTag();
        DPSpawners.handItems(entityTag, goldAxe, 0.085f);
        spawns.m_146271_((Object)SpawnerAccessHelper.createSpawnerEntity((EntityType)EntityType.f_20562_, (CompoundTag)entityTag, Optional.empty()), 1);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (SimpleWeightedRandomList)spawns.m_146270_());
    }

    private static void soulPrisonGhast(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnerAccessHelper.setRequiredPlayerRange((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)32);
        SpawnerAccessHelper.setMaxNearbyEntities((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)10);
        SpawnerAccessHelper.setSpawnCount((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)5);
        SpawnerAccessHelper.setSpawnRange((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (int)16);
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (EntityType)EntityType.f_20453_);
    }

    private static void endRuinsEnderman(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (EntityType)EntityType.f_20566_);
    }

    private static void endRuinsPhantom(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos) {
        SpawnerAccessHelper.setSpawnPotentials((SpawnerBlockEntity)s, (Level)level, (BlockPos)pos, (EntityType)EntityType.f_20509_);
    }

    public static void lootTable(CompoundTag tag, ResourceLocation lootTable) {
        tag.m_128359_("DeathLootTable", lootTable.toString());
    }

    public static void handItems(CompoundTag tag, ItemStack mainHand, float mainHandDropChance, ItemStack offHand, float offHandDropChance) {
        ListTag handItems = new ListTag();
        handItems.add((Object)mainHand.m_41739_(new CompoundTag()));
        handItems.add((Object)offHand.m_41739_(new CompoundTag()));
        tag.m_128365_("HandItems", (Tag)handItems);
        ListTag handDropChances = new ListTag();
        handDropChances.add((Object)FloatTag.m_128566_((float)mainHandDropChance));
        handDropChances.add((Object)FloatTag.m_128566_((float)offHandDropChance));
        tag.m_128365_("HandDropChances", (Tag)handDropChances);
    }

    public static void handItems(CompoundTag tag, ItemStack mainHand, float mainHandDropChance) {
        DPSpawners.handItems(tag, mainHand, mainHandDropChance, ItemStack.f_41583_, 0.085f);
    }

    private static SpawnData basicMob(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos, EntityType<?> type, @Nullable ResourceLocation lootTable, Optional<SpawnData.CustomSpawnRules> customSpawnRules, Consumer<CompoundTag> tagFunc) {
        CompoundTag tag = new CompoundTag();
        tagFunc.accept(tag);
        if (lootTable != null) {
            DPSpawners.lootTable(tag, lootTable);
        }
        return SpawnerAccessHelper.createSpawnerEntity(type, (CompoundTag)tag, customSpawnRules);
    }

    private static SpawnData basicMob(SpawnerBlockEntity s, @Nullable Level level, BlockPos pos, EntityType<?> type, @Nullable ResourceLocation lootTable, Optional<SpawnData.CustomSpawnRules> customSpawnRules) {
        return DPSpawners.basicMob(s, level, pos, type, lootTable, customSpawnRules, tag -> {});
    }
}

