/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.reanimated_ruins;

import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPSpawners;
import com.legacy.dungeons_plus.structures.BlockModifierMap;
import com.legacy.dungeons_plus.structures.PsuedoFeature;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.function.TriFunction;

public enum ReanimatedRuinsType implements StringRepresentable
{
    MOSSY("mossy", DPLoot.ReanimatedRuins.CHEST_MOSSY, DPSpawners.REANIMATED_RUINS_MOSSY, ReanimatedRuinsType.mossyBlockModifier(), ReanimatedRuinsType::mossyFeatures),
    MESA("mesa", DPLoot.ReanimatedRuins.CHEST_DESERT, DPSpawners.REANIMATED_RUINS_DESERT, ReanimatedRuinsType.desertBlockModifier(), ReanimatedRuinsType::desertFeatures),
    FROZEN("frozen", DPLoot.ReanimatedRuins.CHEST_FROZEN, DPSpawners.REANIMATED_RUINS_FROZEN, ReanimatedRuinsType.frozenBlockModifier(), ReanimatedRuinsType::frozenFeatures);

    public static final Codec<ReanimatedRuinsType> CODEC;
    private final String name;
    public final ResourceLocation loot;
    public final DynamicSpawnerType spawner;
    public final BlockModifierMap modifierMap;
    private final PsuedoFeature[] features;

    private ReanimatedRuinsType(String name, ResourceLocation loot, DynamicSpawnerType spawner, BlockModifierMap modifierMap, Consumer<List<PsuedoFeature>> features) {
        this.name = name;
        this.loot = loot;
        this.spawner = spawner;
        this.modifierMap = modifierMap;
        ArrayList featuresList = new ArrayList();
        features.accept(featuresList);
        this.features = (PsuedoFeature[])featuresList.toArray(PsuedoFeature[]::new);
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.m_7912_();
    }

    public static ReanimatedRuinsType byName(@Nullable String name) {
        for (ReanimatedRuinsType type : ReanimatedRuinsType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return MOSSY;
    }

    public void decorate(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        for (PsuedoFeature f : this.features) {
            f.place(level, pos, rand);
        }
    }

    private static void mossyFeatures(List<PsuedoFeature> list) {
        list.add(new PsuedoFeature(0, 2, PsuedoFeature.IPlacement.FIND_LOWEST_AIR, ReanimatedRuinsType::puddle));
        list.add(new PsuedoFeature(6, 9, PsuedoFeature.IPlacement.NOOP, ReanimatedRuinsType::mossyStone));
        list.add(new PsuedoFeature(2, 5, PsuedoFeature.IPlacement.NOOP, ReanimatedRuinsType::grassFloor));
        list.add(new PsuedoFeature(2, 5, PsuedoFeature.IPlacement.FIND_LOWEST_AIR, ReanimatedRuinsType::dripleaf));
        list.add(new PsuedoFeature(2, 6, PsuedoFeature.IPlacement.FIND_LOWEST_AIR, ReanimatedRuinsType::tallGrass));
        list.add(new PsuedoFeature(8, 15, PsuedoFeature.IPlacement.FIND_HIGHEST_AIR, ReanimatedRuinsType::caveVines));
    }

    private static void desertFeatures(List<PsuedoFeature> list) {
        list.add(new PsuedoFeature(2, 6, PsuedoFeature.IPlacement.FIND_LOWEST_AIR, ReanimatedRuinsType::deadBush));
        list.add(new PsuedoFeature(0, 6, PsuedoFeature.IPlacement.FIND_HIGHEST_AIR, ReanimatedRuinsType::dripstone));
    }

    private static void frozenFeatures(List<PsuedoFeature> list) {
        list.add(new PsuedoFeature(0, 2, PsuedoFeature.IPlacement.FIND_HIGHEST_AIR, ReanimatedRuinsType::ice));
        list.add(new PsuedoFeature(0, 2, PsuedoFeature.IPlacement.NOOP, ReanimatedRuinsType::diorite));
        list.add(new PsuedoFeature(2, 5, PsuedoFeature.IPlacement.NOOP, ReanimatedRuinsType::calciteFloor));
        list.add(new PsuedoFeature(2, 6, PsuedoFeature.IPlacement.FIND_LOWEST_AIR, ReanimatedRuinsType::snowPatch));
        list.add(new PsuedoFeature(2, 6, PsuedoFeature.IPlacement.NOOP, ReanimatedRuinsType::glowLichen));
    }

    private static void puddle(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        pos = pos.m_7495_();
        ReanimatedRuinsType.placeWater(level, pos);
        for (Direction dir : DPUtil.HORIZONTAL_DIR) {
            if (!rand.m_188499_()) continue;
            ReanimatedRuinsType.placeWater(level, pos.m_121945_(dir));
        }
    }

    private static void placeWater(ServerLevelAccessor level, BlockPos pos) {
        if (level.m_8055_(pos).m_60713_(Blocks.f_50069_) && level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 2);
            level.m_7731_(pos.m_7495_(), Blocks.f_50069_.m_49966_(), 2);
        }
    }

    private static void mossyStone(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        DPUtil.fillBlob(level, pos, 4, (TriFunction<ServerLevelAccessor, BlockPos, RandomSource, BlockState>)((TriFunction)(l, p, r) -> {
            BlockState s = level.m_8055_(p);
            if (s.m_60713_(Blocks.f_50652_)) {
                return Blocks.f_50079_.m_49966_();
            }
            if (s.m_60713_(Blocks.f_50222_)) {
                return Blocks.f_50223_.m_49966_();
            }
            if (s.m_60713_(Blocks.f_50176_)) {
                return Blocks.f_50177_.m_49966_();
            }
            if (s.m_60713_(Blocks.f_50411_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50645_.m_49966_(), (BlockState)s);
            }
            if (s.m_60713_(Blocks.f_50194_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50631_.m_49966_(), (BlockState)s);
            }
            return null;
        }), rand, 0.2f);
    }

    private static void grassFloor(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        DPUtil.fillBlob(level, pos, 4, Blocks.f_50440_.m_49966_(), (TriPredicate<ServerLevelAccessor, BlockPos, BlockState>)((TriPredicate)(l, p, s) -> s.m_60713_(Blocks.f_50069_) && l.m_8055_(p.m_7494_()).m_60795_()), rand, 0.6f);
    }

    private static void dripleaf(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        BlockState ground = level.m_8055_(pos.m_7495_());
        if (ground.m_204336_(BlockTags.f_184227_) || ground.m_204336_(BlockTags.f_144278_)) {
            ReanimatedRuinsType.placeFeature(level, pos, rand, CaveFeatures.f_194952_);
        }
    }

    private static void tallGrass(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        BlockState grass = Blocks.f_50034_.m_49966_();
        DPUtil.fillBlob(level, pos, 3, grass, (TriPredicate<ServerLevelAccessor, BlockPos, BlockState>)((TriPredicate)(l, p, s) -> s.m_60795_() && grass.m_60710_((LevelReader)l, p)), rand, 0.5f);
    }

    private static void caveVines(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        if (Blocks.f_152538_.m_49966_().m_60710_((LevelReader)level, pos)) {
            ReanimatedRuinsType.placeFeature(level, pos, rand, CaveFeatures.f_194947_);
        }
    }

    private static void deadBush(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        BlockState deadBush = Blocks.f_50036_.m_49966_();
        DPUtil.fillBlob(level, pos, 3, deadBush, (TriPredicate<ServerLevelAccessor, BlockPos, BlockState>)((TriPredicate)(l, p, s) -> s.m_60795_() && deadBush.m_60710_((LevelReader)l, p)), rand, 0.2f);
    }

    private static void dripstone(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        ReanimatedRuinsType.placeFeature(level, pos, rand, CaveFeatures.f_194941_);
    }

    private static void diorite(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        DPUtil.fillBlob(level, pos, 4, (TriFunction<ServerLevelAccessor, BlockPos, RandomSource, BlockState>)((TriFunction)(l, p, r) -> {
            BlockState s = level.m_8055_(p);
            if (s.m_60713_(Blocks.f_50652_)) {
                return Blocks.f_50228_.m_49966_();
            }
            return null;
        }), rand, 0.85f);
    }

    private static void calciteFloor(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        DPUtil.fillBlob(level, pos, 4, Blocks.f_152497_.m_49966_(), (TriPredicate<ServerLevelAccessor, BlockPos, BlockState>)((TriPredicate)(l, p, s) -> s.m_60713_(Blocks.f_50069_) && l.m_8055_(p.m_7494_()).m_60795_()), rand, 0.6f);
    }

    private static void ice(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        DPUtil.fillBlob(level, pos, 4, Blocks.f_50354_.m_49966_(), (TriPredicate<ServerLevelAccessor, BlockPos, BlockState>)((TriPredicate)(l, p, s) -> s.m_60713_(Blocks.f_50652_) && l.m_8055_(p.m_7495_()).m_60795_()), rand, 0.75f);
    }

    private static void snowPatch(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        BlockState snow = Blocks.f_50125_.m_49966_();
        DPUtil.fillBlob(level, pos, 3, snow, (TriPredicate<ServerLevelAccessor, BlockPos, BlockState>)((TriPredicate)(l, p, s) -> s.m_60795_() && snow.m_60710_((LevelReader)l, p)), rand, 0.75f);
    }

    private static void glowLichen(ServerLevelAccessor level, BlockPos pos, RandomSource rand) {
        ReanimatedRuinsType.placeFeature(level, pos, rand, CaveFeatures.f_194945_);
    }

    private static void placeFeature(ServerLevelAccessor level, BlockPos pos, RandomSource rand, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey) {
        if (level instanceof WorldGenLevel) {
            WorldGenLevel wgLevel = (WorldGenLevel)level;
            level.m_8891_().m_255025_(Registries.f_256911_).m_254902_(configuredFeatureKey).ifPresent(f -> ((ConfiguredFeature)f.m_203334_()).m_224953_(wgLevel, wgLevel.m_6018_().m_7726_().m_8481_(), rand, pos));
        }
    }

    private static BlockModifierMap mossyBlockModifier() {
        return (BlockModifierMap)Util.m_137469_((Object)new BlockModifierMap(), map -> {
            map.put(Blocks.f_152482_, ReanimatedRuinsType.candleFunc(Blocks.f_152518_, false));
            map.put(Blocks.f_152470_, (s, r) -> r.m_188501_() < 0.1f ? IModifyState.mergeStates((BlockState)Blocks.f_152471_.m_49966_(), (BlockState)s) : s);
        });
    }

    private static BlockModifierMap desertBlockModifier() {
        return (BlockModifierMap)Util.m_137469_((Object)new BlockModifierMap(), map -> {
            map.put(Blocks.f_152482_, ReanimatedRuinsType.candleFunc(Blocks.f_152523_, true));
            map.put(Blocks.f_50652_, Blocks.f_50122_);
            map.put(Blocks.f_50227_, Blocks.f_50122_);
            map.merge(Blocks.f_50409_, Blocks.f_50651_);
            map.merge(Blocks.f_50157_, Blocks.f_50638_);
            map.merge(Blocks.f_50274_, Blocks.f_50608_);
            map.put(Blocks.f_50069_, Blocks.f_50352_);
            map.merge(Blocks.f_50404_, Blocks.f_50643_);
            map.merge(Blocks.f_50635_, Blocks.f_50629_);
            map.put(Blocks.f_50222_, Blocks.f_50396_);
            map.put(Blocks.f_50176_, Blocks.f_50396_);
            map.put(Blocks.f_50224_, Blocks.f_50394_);
            map.put(Blocks.f_50178_, Blocks.f_50394_);
            map.put(Blocks.f_50225_, Blocks.f_50395_);
            map.put(Blocks.f_50179_, Blocks.f_50395_);
            map.merge(Blocks.f_50411_, Blocks.f_50468_);
            map.merge(Blocks.f_50194_, Blocks.f_50397_);
            map.merge(Blocks.f_50609_, Blocks.f_50606_);
        });
    }

    private static BlockModifierMap frozenBlockModifier() {
        return (BlockModifierMap)Util.m_137469_((Object)new BlockModifierMap(), map -> map.put(Blocks.f_152482_, ReanimatedRuinsType.candleFunc(Blocks.f_152483_, false)));
    }

    private static BiFunction<BlockState, RandomSource, BlockState> candleFunc(Block candle, boolean lit) {
        return (s, r) -> r.m_188501_() < 0.65f ? (BlockState)IModifyState.mergeStates((BlockState)candle.m_49966_(), (BlockState)s).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(lit)) : Blocks.f_50016_.m_49966_();
    }

    static {
        CODEC = StringRepresentable.m_216439_(ReanimatedRuinsType::values);
    }
}

