/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.snowy_temple;

import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.dungeons_plus.structures.snowy_temple.SnowyTemplePieces;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class SnowyTempleStructure
extends Structure {
    public static final Codec<SnowyTempleStructure> CODEC = SnowyTempleStructure.m_226607_(SnowyTempleStructure::new);

    public SnowyTempleStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return SnowyTempleStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, pieces -> SnowyTempleStructure.generatePieces(pieces, context));
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom rand = context.f_226626_();
        int samples = 1;
        int y = context.f_226622_().m_223235_(chunkPos.m_151382_(8), chunkPos.m_151391_(8), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        int width = 25;
        for (int x = 0; x < 1; ++x) {
            for (int z = 0; z < 1; ++z) {
                y += context.f_226622_().m_223235_(chunkPos.m_151382_(x * width), chunkPos.m_151391_(z * width), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
                ++samples;
            }
        }
        BlockPos pos = new BlockPos(chunkPos.f_45578_ << 4, y / samples, chunkPos.f_45579_ << 4);
        SnowyTemplePieces.assemble(context.f_226625_(), pos, Rotation.m_221990_((RandomSource)rand), builder, (RandomSource)rand);
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, PiecesContainer pieces) {
        DPUtil.fillBelow(level, rand, bounds, pieces, (b, r) -> b);
    }

    public StructureType<?> m_213658_() {
        return DPStructures.SNOWY_TEMPLE.getType();
    }
}

