/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.api;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.util.Pair;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public interface Material<D extends InstanceData> {
    public Instancer<D> model(Object var1, Supplier<Model> var2);

    default public Instancer<D> getModel(PartialModel partial, BlockState referenceState) {
        return this.model(partial, () -> new BlockModel(partial.get(), referenceState));
    }

    default public Instancer<D> getModel(PartialModel partial) {
        return this.model(partial, () -> new BlockModel(partial.get(), Blocks.f_50016_.m_49966_()));
    }

    default public Instancer<D> getModel(PartialModel partial, BlockState referenceState, Direction dir) {
        return this.getModel(partial, referenceState, dir, ModelUtil.rotateToFace(dir));
    }

    default public Instancer<D> getModel(PartialModel partial, BlockState referenceState, Direction dir, Supplier<PoseStack> modelTransform) {
        return this.model(Pair.of(dir, partial), () -> new BlockModel(partial.get(), referenceState, (PoseStack)modelTransform.get()));
    }

    default public Instancer<D> getModel(BlockState toRender) {
        return this.model(toRender, () -> new BlockModel(toRender));
    }
}

