/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.AbstractInstance;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.TickingLightListener;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class EntityInstance<E extends Entity>
extends AbstractInstance
implements LightListener,
TickingLightListener {
    protected final E entity;
    protected final GridAlignedBB bounds;

    public EntityInstance(MaterialManager materialManager, E entity) {
        super(materialManager, ((Entity)entity).f_19853_);
        this.entity = entity;
        this.bounds = GridAlignedBB.from(entity.m_20191_());
    }

    @Override
    public GridAlignedBB getVolume() {
        return this.bounds;
    }

    @Override
    public boolean tickLightListener() {
        AABB boundsNow = this.entity.m_20191_();
        if (this.bounds.sameAs(boundsNow)) {
            return false;
        }
        this.bounds.assign(boundsNow);
        this.updateLight();
        return true;
    }

    public Vector3f getInstancePosition() {
        Vec3 pos = this.entity.m_20182_();
        Vec3i origin = this.materialManager.getOriginCoordinate();
        return new Vector3f((float)(pos.f_82479_ - (double)origin.m_123341_()), (float)(pos.f_82480_ - (double)origin.m_123342_()), (float)(pos.f_82481_ - (double)origin.m_123343_()));
    }

    public Vector3f getInstancePosition(float partialTicks) {
        Vec3 pos = this.entity.m_20182_();
        Vec3i origin = this.materialManager.getOriginCoordinate();
        return new Vector3f((float)(Mth.m_14139_((double)partialTicks, (double)((Entity)this.entity).f_19790_, (double)pos.f_82479_) - (double)origin.m_123341_()), (float)(Mth.m_14139_((double)partialTicks, (double)((Entity)this.entity).f_19791_, (double)pos.f_82480_) - (double)origin.m_123342_()), (float)(Mth.m_14139_((double)partialTicks, (double)((Entity)this.entity).f_19792_, (double)pos.f_82481_) - (double)origin.m_123343_()));
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.entity.m_20183_();
    }
}

