/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.MappedGlBuffer;
import com.jozufozu.flywheel.util.Lazy;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class FullscreenQuad {
    public static final Lazy<FullscreenQuad> INSTANCE = Lazy.of(FullscreenQuad::new);
    private static final float[] vertices = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final int bufferSize = vertices.length * 4;
    private final GlVertexArray vao;
    private final GlBuffer vbo = new MappedGlBuffer(GlBufferType.ARRAY_BUFFER);

    private FullscreenQuad() {
        this.vbo.bind();
        this.vbo.ensureCapacity(bufferSize);
        try (MappedBuffer buffer = this.vbo.getBuffer();){
            buffer.putFloatArray(vertices);
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Could not create fullscreen quad.", (Throwable)e);
        }
        this.vao = new GlVertexArray();
        this.vao.bind();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)4, (int)GlNumericType.FLOAT.getGlEnum(), (boolean)false, (int)16, (long)0L);
        GlVertexArray.unbind();
        this.vbo.unbind();
    }

    public void draw() {
        this.vao.bind();
        GL11.glDrawArrays((int)4, (int)0, (int)6);
        GlVertexArray.unbind();
    }

    public void delete() {
        this.vao.delete();
        this.vbo.delete();
    }
}

