/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.core.shader.GameStateProvider;
import com.jozufozu.flywheel.core.shader.ShaderConstants;
import com.jozufozu.flywheel.core.shader.StateSnapshot;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class GameStateRegistry {
    private static final List<GameStateProvider> PROVIDERS = new ArrayList<GameStateProvider>();

    public static void register(GameStateProvider provider) {
        PROVIDERS.add(provider);
    }

    public static StateSnapshot takeSnapshot() {
        BitSet bitSet = new BitSet(PROVIDERS.size());
        int listSize = PROVIDERS.size();
        for (int i = 0; i < listSize; ++i) {
            if (!PROVIDERS.get(i).isTrue()) continue;
            bitSet.set(i);
        }
        return new StateSnapshot(bitSet);
    }

    public static ShaderConstants getShaderConstants(StateSnapshot snapshot) {
        BitSet ctx = snapshot.ctx();
        ShaderConstants shaderConstants = new ShaderConstants();
        int listSize = PROVIDERS.size();
        for (int i = 0; i < listSize; ++i) {
            if (!ctx.get(i)) continue;
            PROVIDERS.get(i).alterConstants(shaderConstants);
        }
        return shaderConstants;
    }

    public static void _clear() {
        PROVIDERS.clear();
    }
}

