/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.TextureStitchEvent;

public class StitchedSprite {
    private static final Map<ResourceLocation, List<StitchedSprite>> ALL = new HashMap<ResourceLocation, List<StitchedSprite>>();
    protected final ResourceLocation atlasLocation;
    protected final ResourceLocation location;
    protected TextureAtlasSprite sprite;

    public StitchedSprite(ResourceLocation atlas, ResourceLocation location) {
        this.atlasLocation = atlas;
        this.location = location;
        ALL.computeIfAbsent(this.atlasLocation, $ -> new ArrayList()).add(this);
    }

    public StitchedSprite(ResourceLocation location) {
        this(InventoryMenu.f_39692_, location);
    }

    public static void onTextureStitchPost(TextureStitchEvent.Post event) {
        TextureAtlas atlas = event.getAtlas();
        ResourceLocation atlasLocation = atlas.m_118330_();
        List<StitchedSprite> sprites = ALL.get(atlasLocation);
        if (sprites != null) {
            for (StitchedSprite sprite : sprites) {
                sprite.loadSprite(atlas);
            }
        }
    }

    protected void loadSprite(TextureAtlas atlas) {
        this.sprite = atlas.m_118316_(this.location);
    }

    public ResourceLocation getAtlasLocation() {
        return this.atlasLocation;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public TextureAtlasSprite get() {
        return this.sprite;
    }
}

