/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.materials.model;

import com.jozufozu.flywheel.core.materials.BasicData;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ModelData
extends BasicData
implements Transform<ModelData> {
    public final Matrix4f model = new Matrix4f();
    public final Matrix3f normal = new Matrix3f();

    public ModelData setTransform(PoseStack stack) {
        this.markDirty();
        this.model.set((Matrix4fc)stack.m_85850_().m_252922_());
        this.normal.set((Matrix3fc)stack.m_85850_().m_252943_());
        return this;
    }

    public ModelData setEmptyTransform() {
        this.markDirty();
        this.model.zero();
        this.normal.zero();
        return this;
    }

    public ModelData loadIdentity() {
        this.markDirty();
        this.model.identity();
        this.normal.identity();
        return this;
    }

    @Override
    public ModelData multiply(Quaternionf quaternion) {
        this.markDirty();
        this.model.rotate((Quaternionfc)quaternion);
        this.normal.rotate((Quaternionfc)quaternion);
        return this;
    }

    @Override
    public ModelData scale(float pX, float pY, float pZ) {
        this.markDirty();
        this.model.scale(pX, pY, pZ);
        if (pX == pY && pY == pZ) {
            if (pX > 0.0f) {
                return this;
            }
            this.normal.scale(-1.0f);
        }
        float f = 1.0f / pX;
        float f1 = 1.0f / pY;
        float f2 = 1.0f / pZ;
        float f3 = Mth.m_14199_((float)(f * f1 * f2));
        this.normal.scale(f3 * f, f3 * f1, f3 * f2);
        return this;
    }

    @Override
    public ModelData translate(double x, double y, double z) {
        this.markDirty();
        this.model.translate((float)x, (float)y, (float)z);
        return this;
    }

    @Override
    public ModelData mulPose(Matrix4f pose) {
        this.model.mul((Matrix4fc)pose);
        return this;
    }

    @Override
    public ModelData mulNormal(Matrix3f normal) {
        this.normal.mul((Matrix3fc)normal);
        return this;
    }
}

