/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.model.BufferBuilderExtension;
import com.jozufozu.flywheel.core.model.BakedModelBuilder;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.core.model.WorldModelBuilder;
import com.jozufozu.flywheel.util.Pair;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ModelUtil {
    public static final BlockRenderDispatcher VANILLA_RENDERER = ModelUtil.createVanillaRenderer();
    public static final ModelProperty<Boolean> VIRTUAL_PROPERTY = new ModelProperty();
    public static final ModelData VIRTUAL_DATA = ModelData.builder().with(VIRTUAL_PROPERTY, (Object)true).build();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private static BlockRenderDispatcher createVanillaRenderer() {
        BlockRenderDispatcher defaultDispatcher = Minecraft.m_91087_().m_91289_();
        BlockRenderDispatcher dispatcher = new BlockRenderDispatcher(null, null, null);
        try {
            for (Field field : BlockRenderDispatcher.class.getDeclaredFields()) {
                field.setAccessible(true);
                field.set(dispatcher, field.get(defaultDispatcher));
            }
            ObfuscationReflectionHelper.setPrivateValue(BlockRenderDispatcher.class, (Object)dispatcher, (Object)new ModelBlockRenderer(Minecraft.m_91087_().m_91298_()), (String)"f_110900_");
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Failed to initialize vanilla BlockRenderDispatcher!", (Throwable)e);
            return defaultDispatcher;
        }
        return dispatcher;
    }

    public static boolean isVirtual(ModelData data) {
        return data.has(VIRTUAL_PROPERTY) && (Boolean)data.get(VIRTUAL_PROPERTY) != false;
    }

    public static Pair<BufferBuilder.RenderedBuffer, Integer> endShadeSeparated(BufferBuilder shadedBuilder, BufferBuilder unshadedBuilder) {
        int unshadedStartVertex = ((BufferBuilderExtension)shadedBuilder).flywheel$getVertices();
        BufferBuilder.RenderedBuffer unshadedBuffer = unshadedBuilder.m_231168_();
        if (unshadedBuffer != null) {
            ((BufferBuilderExtension)shadedBuilder).flywheel$appendBufferUnsafe(unshadedBuffer.m_231196_());
            unshadedBuffer.m_231200_();
        }
        BufferBuilder.RenderedBuffer buffer = shadedBuilder.m_231175_();
        return Pair.of(buffer, unshadedStartVertex);
    }

    public static Pair<BufferBuilder.RenderedBuffer, Integer> getRenderedBuffer(Bufferable bufferable) {
        ModelBlockRenderer blockRenderer = VANILLA_RENDERER.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        objects.begin();
        bufferable.bufferInto(blockRenderer, objects.shadeSeparatingWrapper, objects.random);
        return objects.end();
    }

    public static Pair<BufferBuilder.RenderedBuffer, Integer> getBufferBuilder(BakedModel model, BlockState referenceState, PoseStack poseStack) {
        return new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(poseStack).build();
    }

    public static Pair<BufferBuilder.RenderedBuffer, Integer> getBufferBuilder(BlockAndTintGetter renderWorld, BakedModel model, BlockState referenceState, PoseStack poseStack) {
        return new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(poseStack).withRenderWorld(renderWorld).build();
    }

    public static Pair<BufferBuilder.RenderedBuffer, Integer> getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks) {
        return new WorldModelBuilder(layer).withRenderWorld(renderWorld).withBlocks(blocks).build();
    }

    public static Pair<BufferBuilder.RenderedBuffer, Integer> getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks, PoseStack poseStack) {
        return new WorldModelBuilder(layer).withRenderWorld(renderWorld).withBlocks(blocks).withPoseStack(poseStack).build();
    }

    public static Supplier<PoseStack> rotateToFace(Direction facing) {
        return () -> {
            PoseStack stack = new PoseStack();
            ((TransformStack)((TransformStack)TransformStack.cast(stack).centre()).rotateToFace(facing.m_122424_())).unCentre();
            return stack;
        };
    }

    private static class ThreadLocalObjects {
        public final RandomSource random = RandomSource.m_216327_();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final BufferBuilder shadedBuilder = new BufferBuilder(512);
        public final BufferBuilder unshadedBuilder = new BufferBuilder(512);

        private ThreadLocalObjects() {
        }

        private void begin() {
            this.shadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            this.unshadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            this.shadeSeparatingWrapper.prepare((VertexConsumer)this.shadedBuilder, (VertexConsumer)this.unshadedBuilder);
        }

        private Pair<BufferBuilder.RenderedBuffer, Integer> end() {
            this.shadeSeparatingWrapper.clear();
            return ModelUtil.endShadeSeparated(this.shadedBuilder, this.unshadedBuilder);
        }
    }
}

