/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.virtual;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import com.jozufozu.flywheel.core.virtual.VirtualChunkSection;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.Mods;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.TickContainerAccess;

public class VirtualChunk
extends ChunkAccess {
    final VirtualRenderWorld world;
    boolean needsLight;
    final int x;
    final int z;
    private final LevelChunkSection[] sections;

    public VirtualChunk(VirtualRenderWorld world, int x, int z) {
        super(new ChunkPos(x, z), UpgradeData.f_63320_, (LevelHeightAccessor)world, world.m_8891_().m_175515_(Registries.f_256952_), 0L, null, null);
        this.world = world;
        this.needsLight = true;
        this.x = x;
        this.z = z;
        int sectionCount = world.m_151559_();
        this.sections = new LevelChunkSection[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            this.sections[i] = new VirtualChunkSection(this, i << 4);
        }
        Mods.STARLIGHT.executeIfInstalled(() -> () -> {
            ((ExtendedChunk)this).setBlockNibbles(StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)this));
            ((ExtendedChunk)this).setSkyNibbles(StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)this));
        });
    }

    public Stream<BlockPos> m_6267_() {
        return this.world.blocksAdded.entrySet().stream().filter(it -> {
            BlockPos blockPos = (BlockPos)it.getKey();
            boolean chunkContains = blockPos.m_123341_() >> 4 == this.x && blockPos.m_123343_() >> 4 == this.z;
            return chunkContains && ((BlockState)it.getValue()).getLightEmission((BlockGetter)this.world, blockPos) != 0;
        }).map(Map.Entry::getKey);
    }

    public LevelChunkSection[] m_7103_() {
        return this.sections;
    }

    public ChunkStatus m_6415_() {
        return ChunkStatus.f_62323_;
    }

    @Nullable
    public BlockState m_6978_(BlockPos p_177436_1_, BlockState p_177436_2_, boolean p_177436_3_) {
        return null;
    }

    public void m_142169_(BlockEntity p_177426_2_) {
    }

    public void m_6286_(Entity p_76612_1_) {
    }

    public Set<BlockPos> m_5928_() {
        return null;
    }

    public Collection<Map.Entry<Heightmap.Types, Heightmap>> m_6890_() {
        return null;
    }

    public void m_6511_(Heightmap.Types p_201607_1_, long[] p_201607_2_) {
    }

    public Heightmap m_6005_(Heightmap.Types p_217303_1_) {
        return null;
    }

    public int m_5885_(Heightmap.Types p_201576_1_, int p_201576_2_, int p_201576_3_) {
        return 0;
    }

    public void m_8092_(boolean p_177427_1_) {
    }

    public boolean m_6344_() {
        return false;
    }

    public void m_8114_(BlockPos p_177425_1_) {
    }

    public ShortList[] m_6720_() {
        return new ShortList[0];
    }

    @Nullable
    public CompoundTag m_8049_(BlockPos p_201579_1_) {
        return null;
    }

    @Nullable
    public CompoundTag m_8051_(BlockPos p_223134_1_) {
        return null;
    }

    public UpgradeData m_7387_() {
        return null;
    }

    public void m_6141_(long p_177415_1_) {
    }

    public long m_6319_() {
        return 0L;
    }

    public boolean m_6332_() {
        return this.needsLight;
    }

    public void m_8094_(boolean needsLight) {
        this.needsLight = needsLight;
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return null;
    }

    public BlockState m_8055_(BlockPos pos) {
        return this.world.m_8055_(pos);
    }

    public FluidState m_6425_(BlockPos p_204610_1_) {
        return null;
    }

    @Nullable
    public StructureStart m_213652_(Structure structure) {
        return null;
    }

    public void m_213792_(Structure structure, StructureStart start) {
    }

    public Map<Structure, StructureStart> m_6633_() {
        return Collections.emptyMap();
    }

    public void m_8040_(Map<Structure, StructureStart> structureStarts) {
    }

    public LongSet m_213649_(Structure structure) {
        return LongSets.emptySet();
    }

    public void m_213843_(Structure structure, long reference) {
    }

    public Map<Structure, LongSet> m_62769_() {
        return Collections.emptyMap();
    }

    public void m_62737_(Map<Structure, LongSet> structureReferences) {
    }

    public int m_141928_() {
        return this.world.m_141928_();
    }

    public int m_141937_() {
        return this.world.m_141937_();
    }

    public TickContainerAccess<Fluid> m_183526_() {
        return BlackholeTickAccess.m_193144_();
    }

    public ChunkAccess.TicksToSave m_183568_() {
        return null;
    }

    public TickContainerAccess<Block> m_183531_() {
        return BlackholeTickAccess.m_193144_();
    }
}

