/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.light;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.ParallelTaskEngine;
import com.jozufozu.flywheel.light.DummyLightUpdater;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightUpdated;
import com.jozufozu.flywheel.light.TickingLightListener;
import com.jozufozu.flywheel.light.WeakContainmentMultiMap;
import com.jozufozu.flywheel.util.WeakHashSet;
import com.jozufozu.flywheel.util.WorldAttached;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;

public class LightUpdater {
    private static final WorldAttached<LightUpdater> LEVELS = new WorldAttached<LightUpdater>(LightUpdater::new);
    private final ParallelTaskEngine taskEngine;
    private final LevelAccessor level;
    private final WeakHashSet<TickingLightListener> tickingLightListeners = new WeakHashSet();
    private final WeakContainmentMultiMap<LightListener> sections = new WeakContainmentMultiMap();
    private final WeakContainmentMultiMap<LightListener> chunks = new WeakContainmentMultiMap();

    public static LightUpdater get(LevelAccessor level) {
        if (LightUpdated.receivesLightUpdates(level)) {
            return LEVELS.get(level);
        }
        return DummyLightUpdater.INSTANCE;
    }

    public LightUpdater(LevelAccessor level) {
        this.taskEngine = Backend.getTaskEngine();
        this.level = level;
    }

    public void tick() {
        this.tickSerial();
    }

    private void tickSerial() {
        for (TickingLightListener tickingLightListener : this.tickingLightListeners) {
            if (!tickingLightListener.tickLightListener()) continue;
            this.addListener(tickingLightListener);
        }
    }

    private void tickParallel() {
        ConcurrentLinkedQueue listeners = new ConcurrentLinkedQueue();
        this.taskEngine.group("LightUpdater").addTasks(this.tickingLightListeners.stream(), listener -> {
            if (listener.tickLightListener()) {
                listeners.add(listener);
            }
        }).onComplete(() -> listeners.forEach(this::addListener)).submit();
    }

    public void addListener(LightListener listener) {
        if (listener instanceof TickingLightListener) {
            this.tickingLightListeners.add((TickingLightListener)listener);
        }
        ImmutableBox box = listener.getVolume();
        LongSet sections = this.sections.getAndResetContainment(listener);
        LongSet chunks = this.chunks.getAndResetContainment(listener);
        int minX = SectionPos.m_123171_((int)box.getMinX());
        int minY = SectionPos.m_123171_((int)box.getMinY());
        int minZ = SectionPos.m_123171_((int)box.getMinZ());
        int maxX = SectionPos.m_123171_((int)box.getMaxX());
        int maxY = SectionPos.m_123171_((int)box.getMaxY());
        int maxZ = SectionPos.m_123171_((int)box.getMaxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    long sectionPos = SectionPos.m_123209_((int)x, (int)y, (int)z);
                    this.sections.put(sectionPos, listener);
                    sections.add(sectionPos);
                }
                long chunkPos = SectionPos.m_123209_((int)x, (int)0, (int)z);
                this.chunks.put(chunkPos, listener);
                chunks.add(chunkPos);
            }
        }
    }

    public void removeListener(LightListener listener) {
        this.sections.remove(listener);
        this.chunks.remove(listener);
    }

    public void onLightUpdate(LightLayer type, long sectionPos) {
        Set<LightListener> set = this.sections.get(sectionPos);
        if (set == null || set.isEmpty()) {
            return;
        }
        set.removeIf(LightListener::isListenerInvalid);
        GridAlignedBB chunkBox = GridAlignedBB.from(SectionPos.m_123184_((long)sectionPos));
        for (LightListener listener : set) {
            listener.onLightUpdate(type, chunkBox);
        }
    }

    public void onLightPacket(int chunkX, int chunkZ) {
        long chunkPos = SectionPos.m_123209_((int)chunkX, (int)0, (int)chunkZ);
        Set<LightListener> set = this.chunks.get(chunkPos);
        if (set == null || set.isEmpty()) {
            return;
        }
        set.removeIf(LightListener::isListenerInvalid);
        for (LightListener listener : set) {
            listener.onLightPacket(chunkX, chunkZ);
        }
    }

    public static long blockToSection(BlockPos pos) {
        return SectionPos.m_123209_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
    }

    public static long sectionToChunk(long sectionPos) {
        return sectionPos & 0xFFFFFFFFFFF00000L;
    }

    public Stream<ImmutableBox> getAllBoxes() {
        return this.chunks.stream().map(LightListener::getVolume);
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }
}

