/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import java.util.Objects;

public record Pair<F, S>(F first, S second) {
    public static <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public Pair<S, F> swap() {
        return Pair.of(this.second, this.first);
    }

    public Pair<F, S> copy() {
        return Pair.of(this.first, this.second);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Pair.nullHash(this.first) * 31 ^ Pair.nullHash(this.second);
    }

    @Override
    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    static int nullHash(Object o) {
        return o == null ? 0 : o.hashCode();
    }
}

