/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util.transform;

import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface Rotate<Self> {
    public Self multiply(Quaternionf var1);

    default public Self rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return (Self)this;
        }
        return this.multiply(new Quaternionf().rotationAxis(radians, (Vector3fc)axis.m_253071_()));
    }

    default public Self rotate(double angle, Direction.Axis axis) {
        Axis vec = axis == Direction.Axis.X ? Axis.f_252529_ : (axis == Direction.Axis.Y ? Axis.f_252436_ : Axis.f_252403_);
        return this.multiply(vec, angle);
    }

    default public Self rotateX(double angle) {
        return this.multiply(Axis.f_252529_, angle);
    }

    default public Self rotateY(double angle) {
        return this.multiply(Axis.f_252436_, angle);
    }

    default public Self rotateZ(double angle) {
        return this.multiply(Axis.f_252403_, angle);
    }

    default public Self rotateXRadians(double angle) {
        return this.multiplyRadians(Axis.f_252529_, angle);
    }

    default public Self rotateYRadians(double angle) {
        return this.multiplyRadians(Axis.f_252436_, angle);
    }

    default public Self rotateZRadians(double angle) {
        return this.multiplyRadians(Axis.f_252403_, angle);
    }

    default public Self multiply(Axis axis, double angle) {
        if (angle == 0.0) {
            return (Self)this;
        }
        return this.multiply(axis.m_252977_((float)angle));
    }

    default public Self multiplyRadians(Axis axis, double angle) {
        if (angle == 0.0) {
            return (Self)this;
        }
        return this.multiply(axis.m_252961_((float)angle));
    }

    default public Self multiply(Vector3f axis, double angle) {
        if (angle == 0.0) {
            return (Self)this;
        }
        return this.multiply(new Quaternionf(new AxisAngle4f((float)Math.toRadians(angle), (Vector3fc)axis)));
    }

    default public Self multiplyRadians(Vector3f axis, double angle) {
        if (angle == 0.0) {
            return (Self)this;
        }
        return this.multiply(new Quaternionf(new AxisAngle4f((float)angle, (Vector3fc)axis)));
    }

    default public Self rotateToFace(Direction facing) {
        switch (facing) {
            case SOUTH: {
                this.multiply(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                this.multiply(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                this.multiply(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                this.multiply(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case UP: {
                this.multiply(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                this.multiply(Axis.f_252495_.m_252977_(90.0f));
            }
        }
        return (Self)this;
    }
}

