/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BellInstance
extends BlockEntityInstance<BellBlockEntity>
implements DynamicInstance {
    private final OrientedData bell;
    private float lastRingTime = Float.NaN;

    public BellInstance(MaterialManager materialManager, BellBlockEntity blockEntity) {
        super(materialManager, blockEntity);
        this.bell = this.createBellInstance().setPivot(0.5f, 0.75f, 0.5f).setPosition(this.getInstancePosition());
    }

    @Override
    public void beginFrame() {
        float ringTime = (float)((BellBlockEntity)this.blockEntity).f_58813_ + AnimationTickHolder.getPartialTicks();
        if (ringTime == this.lastRingTime) {
            return;
        }
        this.lastRingTime = ringTime;
        if (((BellBlockEntity)this.blockEntity).f_58814_) {
            float angle = Mth.m_14031_((float)(ringTime / (float)Math.PI)) / (4.0f + ringTime / 3.0f);
            Vector3f ringAxis = ((BellBlockEntity)this.blockEntity).f_58815_.m_122428_().m_253071_();
            this.bell.setRotation(new Quaternionf().rotationAxis(angle, (Vector3fc)ringAxis));
        } else {
            this.bell.setRotation(new Quaternionf());
        }
    }

    @Override
    public void updateLight() {
        this.relight(this.getWorldPosition(), this.bell);
    }

    @Override
    public void remove() {
        this.bell.delete();
    }

    private OrientedData createBellInstance() {
        return this.materialManager.defaultCutout().material(Materials.ORIENTED).model(((BellBlockEntity)this.blockEntity).m_58903_(), BellInstance::createBellModel).createInstance();
    }

    private static ModelPart createBellModel() {
        return ModelPart.builder("bell", 32, 32).sprite(BellRenderer.f_112227_.m_119204_()).cuboid().start(5.0f, 6.0f, 5.0f).size(6.0f, 7.0f, 6.0f).endCuboid().cuboid().textureOffset(0, 13).start(4.0f, 4.0f, 4.0f).size(8.0f, 2.0f, 8.0f).endCuboid().build();
    }
}

