/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Calendar;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ChestInstance<T extends BlockEntity>
extends BlockEntityInstance<T>
implements DynamicInstance {
    private final OrientedData body;
    private final ModelData lid;
    private final Float2FloatFunction lidProgress;
    private final Material renderMaterial;
    @Nonnull
    private final ChestType chestType;
    private final Quaternionf baseRotation;
    private float lastProgress = Float.NaN;

    public ChestInstance(MaterialManager materialManager, T blockEntity) {
        super(materialManager, blockEntity);
        Block block = this.blockState.m_60734_();
        this.chestType = this.blockState.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)this.blockState.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        this.renderMaterial = Sheets.m_110767_(blockEntity, (ChestType)this.chestType, (boolean)ChestInstance.isChristmas());
        this.body = this.baseInstance().setPosition(this.getInstancePosition());
        this.lid = this.lidInstance();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock chestBlock = (AbstractChestBlock)block;
            float horizontalAngle = ((Direction)this.blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            this.baseRotation = Axis.f_252436_.m_252977_(-horizontalAngle);
            this.body.setRotation(this.baseRotation);
            DoubleBlockCombiner.NeighborCombineResult wrapper = chestBlock.m_5641_(this.blockState, this.world, this.getWorldPosition(), true);
            this.lidProgress = (Float2FloatFunction)wrapper.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)blockEntity)));
        } else {
            this.baseRotation = new Quaternionf();
            this.lidProgress = $ -> 0.0f;
        }
    }

    @Override
    public void beginFrame() {
        float progress = this.lidProgress.get(AnimationTickHolder.getPartialTicks());
        if (this.lastProgress == progress) {
            return;
        }
        this.lastProgress = progress;
        progress = 1.0f - progress;
        progress = 1.0f - progress * progress * progress;
        float angleX = -(progress * 1.5707964f);
        ((ModelData)((ModelData)((ModelData)this.lid.loadIdentity().translate((Vec3i)this.getInstancePosition())).translate(0.0, 0.5625, 0.0).centre()).multiply(this.baseRotation).unCentre()).translate(0.0, 0.0, 0.0625).multiply(Axis.f_252529_.m_252961_(angleX)).translate(0.0, 0.0, -0.0625);
    }

    @Override
    public void updateLight() {
        this.relight(this.getWorldPosition(), this.body, this.lid);
    }

    @Override
    public void remove() {
        this.body.delete();
        this.lid.delete();
    }

    private OrientedData baseInstance() {
        return this.materialManager.solid(RenderType.m_110446_((ResourceLocation)this.renderMaterial.m_119193_())).material(Materials.ORIENTED).model("base_" + this.renderMaterial.m_119203_(), this::getBaseModel).createInstance();
    }

    private ModelData lidInstance() {
        return this.materialManager.solid(RenderType.m_110446_((ResourceLocation)this.renderMaterial.m_119193_())).material(Materials.TRANSFORMED).model("lid_" + this.renderMaterial.m_119203_(), this::getLidModel).createInstance();
    }

    private ModelPart getBaseModel() {
        return switch (this.chestType) {
            case ChestType.LEFT -> ModelPart.builder("chest_base_left", 64, 64).sprite(this.renderMaterial.m_119204_()).cuboid().textureOffset(0, 19).start(0.0f, 0.0f, 1.0f).size(15.0f, 10.0f, 14.0f).endCuboid().build();
            case ChestType.RIGHT -> ModelPart.builder("chest_base_right", 64, 64).sprite(this.renderMaterial.m_119204_()).cuboid().textureOffset(0, 19).start(1.0f, 0.0f, 1.0f).size(15.0f, 10.0f, 14.0f).endCuboid().build();
            default -> ModelPart.builder("chest_base", 64, 64).sprite(this.renderMaterial.m_119204_()).cuboid().textureOffset(0, 19).start(1.0f, 0.0f, 1.0f).end(15.0f, 10.0f, 15.0f).endCuboid().build();
        };
    }

    private ModelPart getLidModel() {
        return switch (this.chestType) {
            case ChestType.LEFT -> ModelPart.builder("chest_lid_left", 64, 64).sprite(this.renderMaterial.m_119204_()).cuboid().textureOffset(0, 0).start(0.0f, 0.0f, 1.0f).size(15.0f, 5.0f, 14.0f).endCuboid().cuboid().start(0.0f, -2.0f, 15.0f).size(1.0f, 4.0f, 1.0f).endCuboid().build();
            case ChestType.RIGHT -> ModelPart.builder("chest_lid_right", 64, 64).sprite(this.renderMaterial.m_119204_()).cuboid().textureOffset(0, 0).start(1.0f, 0.0f, 1.0f).size(15.0f, 5.0f, 14.0f).endCuboid().cuboid().start(15.0f, -2.0f, 15.0f).size(1.0f, 4.0f, 1.0f).endCuboid().build();
            default -> ModelPart.builder("chest_lid", 64, 64).sprite(this.renderMaterial.m_119204_()).cuboid().textureOffset(0, 0).start(1.0f, 0.0f, 1.0f).size(14.0f, 5.0f, 14.0f).endCuboid().cuboid().start(7.0f, -2.0f, 15.0f).size(2.0f, 4.0f, 1.0f).endCuboid().build();
        };
    }

    public static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }
}

