/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ShulkerBoxInstance
extends BlockEntityInstance<ShulkerBoxBlockEntity>
implements DynamicInstance {
    private final TextureAtlasSprite texture;
    private final ModelData base;
    private final ModelData lid;
    private final PoseStack stack = new PoseStack();
    private float lastProgress = Float.NaN;

    public ShulkerBoxInstance(MaterialManager materialManager, ShulkerBoxBlockEntity blockEntity) {
        super(materialManager, blockEntity);
        DyeColor color = blockEntity.m_59701_();
        this.texture = color == null ? Sheets.f_110741_.m_119204_() : ((Material)Sheets.f_110742_.get(color.m_41060_())).m_119204_();
        Quaternionf rotation = this.getDirection().m_253075_();
        TransformStack tstack = TransformStack.cast(this.stack);
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)tstack.translate((Vec3i)this.getInstancePosition())).scale(0.9995f)).translateAll(2.5E-4)).centre()).multiply(rotation)).unCentre();
        this.base = this.makeBaseInstance().setTransform(this.stack);
        tstack.translateY(0.25);
        this.lid = this.makeLidInstance().setTransform(this.stack);
    }

    @Override
    public void beginFrame() {
        float progress = ((ShulkerBoxBlockEntity)this.blockEntity).m_59657_(AnimationTickHolder.getPartialTicks());
        if (progress == this.lastProgress) {
            return;
        }
        this.lastProgress = progress;
        Quaternionf spin = Axis.f_252436_.m_252977_(270.0f * progress);
        TransformStack tstack = TransformStack.cast(this.stack);
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)tstack.pushPose()).centre()).multiply(spin)).unCentre()).translateY(progress * 0.5f);
        this.lid.setTransform(this.stack);
        this.stack.m_85849_();
    }

    @Override
    public void remove() {
        this.base.delete();
        this.lid.delete();
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.base, this.lid);
    }

    private ModelData makeBaseInstance() {
        return this.materialManager.cutout(RenderType.m_110458_((ResourceLocation)Sheets.f_110735_)).material(Materials.TRANSFORMED).model("base_" + this.texture.m_245424_().m_246162_(), this::makeBaseModel).createInstance();
    }

    private ModelData makeLidInstance() {
        return this.materialManager.cutout(RenderType.m_110458_((ResourceLocation)Sheets.f_110735_)).material(Materials.TRANSFORMED).model("lid_" + this.texture.m_245424_().m_246162_(), this::makeLidModel).createInstance();
    }

    private ModelPart makeBaseModel() {
        return ModelPart.builder("shulker_base", 64, 64).sprite(this.texture).cuboid().textureOffset(0, 28).size(16.0f, 8.0f, 16.0f).invertYZ().endCuboid().build();
    }

    private ModelPart makeLidModel() {
        return ModelPart.builder("shulker_lid", 64, 64).sprite(this.texture).cuboid().size(16.0f, 12.0f, 16.0f).invertYZ().endCuboid().build();
    }

    private Direction getDirection() {
        if (this.blockState.m_60734_() instanceof ShulkerBoxBlock) {
            return (Direction)this.blockState.m_61143_((Property)ShulkerBoxBlock.f_56183_);
        }
        return Direction.UP;
    }
}

