/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.util.LazyOptional;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

public abstract class Registrar<T> {
    private final ResourceLocation name;
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;

    protected Registrar(ResourceKey<Registry<T>> registry, ResourceLocation name) {
        this.name = name;
        this.registryKey = registry;
        this.key = ResourceKey.m_135785_(registry, (ResourceLocation)this.name);
    }

    public static <T, V extends T> Pointer<V> createPointer(ResourceKey<Registry<T>> registry, ResourceLocation name, Supplier<V> value) {
        return Registrar.createPointer(registry, name, (BootstapContext<?> c) -> value.get());
    }

    public static <T, V extends T> Pointer<V> createPointer(ResourceKey<Registry<T>> registry, ResourceLocation name, Function<BootstapContext<?>, V> value) {
        return new Pointer<T>(registry, name, value);
    }

    public static <T, V extends T> Static<V> createStatic(ResourceKey<Registry<T>> registry, ResourceLocation name, Supplier<V> value) {
        return new Static<T>(registry, name, value);
    }

    private void validateRegistry(ResourceKey<? extends Registry<?>> registryKey) throws IllegalArgumentException {
        if (!this.registryKey.equals(registryKey)) {
            throw new IllegalArgumentException("[Structure Gel] Tried to access " + this.key + " from " + registryKey + " but it belongs to " + this.registryKey);
        }
    }

    @Nullable
    public T get(RegistryAccess registryAccess) {
        return this.get(registryAccess.m_175515_(this.registryKey));
    }

    @Nullable
    public T get(CommonLevelAccessor level) {
        return this.get(level.m_8891_());
    }

    @Nullable
    public T get(Registry<?> registry) {
        this.validateRegistry(registry.m_123023_());
        return (T)registry.m_6246_(this.getKey());
    }

    @Nullable
    public T get(IForgeRegistry<?> registry) {
        this.validateRegistry(registry.getRegistryKey());
        return (T)registry.getValue(this.getName());
    }

    @Nullable
    public T orElseGet(Registry<?> registry, Supplier<T> orElse) {
        T val = this.get(registry);
        return val != null ? val : orElse.get();
    }

    @Nullable
    public T orElseGet(IForgeRegistry<?> registry, Supplier<T> orElse) {
        T val = this.get(registry);
        return val != null ? val : orElse.get();
    }

    public boolean isPresent(Registry<?> registry) {
        return registry.m_7804_(this.getName());
    }

    public boolean isPresent(IForgeRegistry<?> registry) {
        return registry.containsKey(this.getName());
    }

    @Nullable
    public <R> R map(Registry<?> registry, Function<T, R> mapFunc) {
        if (this.isPresent(registry)) {
            return mapFunc.apply(this.get(registry));
        }
        return null;
    }

    @Nullable
    public <R> R map(IForgeRegistry<?> registry, Function<T, R> mapFunc) {
        if (this.isPresent(registry)) {
            return mapFunc.apply(this.get(registry));
        }
        return null;
    }

    public Optional<Holder<T>> getHolder(RegistryAccess registryAccess) {
        return this.getHolder(registryAccess.m_175515_(this.registryKey));
    }

    public Optional<Holder<T>> getHolder(CommonLevelAccessor level) {
        return this.getHolder(level.m_8891_());
    }

    public Optional<Holder<T>> getHolder(Registry<?> registry) {
        this.validateRegistry(registry.m_123023_());
        return registry.m_203636_(this.getKey());
    }

    public Optional<Holder.Reference<T>> getHolder(BootstapContext<?> bootstrapContext) {
        return this.getHolder(bootstrapContext.m_255420_(this.registryKey));
    }

    public Optional<Holder.Reference<T>> getHolder(HolderGetter<?> holderGetter) {
        return holderGetter.m_254902_(this.key);
    }

    public Optional<Holder<T>> getHolder(IForgeRegistry<?> registry) {
        this.validateRegistry(registry.getRegistryKey());
        return registry.getHolder(this.getKey());
    }

    public ResourceKey<? extends Registry<?>> getRegistryKey() {
        return this.registryKey;
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public void register(RegisterEvent event) {
        ResourceKey registryKey = event.getRegistryKey();
        if (registryKey.m_135782_().equals((Object)this.getKey().m_211136_())) {
            this.registerValue(event, registryKey);
        }
    }

    protected abstract void registerValue(RegisterEvent var1, ResourceKey<? extends Registry<?>> var2);

    public String toString() {
        return this.getClass().getSimpleName() + "[registry=" + this.registryKey.m_135782_() + ", key=" + this.key.m_135782_() + "]";
    }

    public static class Pointer<T>
    extends Registrar<T> {
        @Nullable
        private final Function<BootstapContext<?>, T> value;

        private Pointer(ResourceKey<Registry<T>> registry, ResourceLocation name, Function<BootstapContext<?>, T> value) {
            super(registry, name);
            this.value = DatagenModLoader.isRunningDataGen() ? value : null;
        }

        @Override
        public void registerValue(RegisterEvent event, ResourceKey<? extends Registry<?>> registryKey) {
        }

        public void registerData(BootstapContext<?> context) {
            if (this.value != null) {
                context.m_255272_(this.getKey(), this.value.apply(context));
            }
        }
    }

    public static class Static<T>
    extends Registrar<T>
    implements Supplier<T> {
        private final LazyOptional<T> valueLazy;

        private Static(ResourceKey<Registry<T>> registry, ResourceLocation name, Supplier<T> value) {
            super(registry, name);
            this.valueLazy = LazyOptional.of(value);
        }

        @Override
        public void registerValue(RegisterEvent event, ResourceKey<? extends Registry<?>> registryKey) {
            if (!this.valueLazy.isPresent()) {
                event.register(registryKey, this.getName(), this.valueLazy);
            }
        }

        @Override
        @Nullable
        public T get() {
            return this.valueLazy.getOrThrow("Attempted to get a value from a Registrar before it was registered. " + this.getKey(), new Object[0]);
        }

        public T orElseGet(Supplier<T> orElse) {
            return this.valueLazy.orElseGet(orElse);
        }

        public boolean isPresent() {
            return this.valueLazy.isPresent();
        }

        @Nullable
        public <R> R map(Function<T, R> mapFunc) {
            if (this.isPresent()) {
                return mapFunc.apply(this.get());
            }
            return null;
        }
    }
}

